;;
;;  Copyright (C) 1991-2011 by Autodesk, Inc.  All Rights Reserved.
;;  Version 2.0
;;  AutoCAD Hatch Patterns
;;
;;
;;  Note: in order to ease migration of this file when upgrading 
;;  to a future version of AutoCAD, it is recommended that you add
;;  your customizations to the User Defined Hatch Patterns section at the
;;  end of this file.
;;


;; Note: Dummy pattern description used for 'Solid fill'.
*SOLID, Solid fill
45, 0,0, 0,.125
*ANGLE, Angle steel
0, 0,0, 0,.275, .2,-.075
90, 0,0, 0,.275, .2,-.075
*ANSI31, ANSI Iron, Brick, Stone masonry
45, 0,0, 0,.125
*ANSI32, ANSI Steel
45, 0,0, 0,.375
45, .176776695,0, 0,.375
*ANSI33, ANSI Bronze, Brass, Copper
45, 0,0, 0,.25
45, .176776695,0, 0,.25, .125,-.0625
*ANSI34, ANSI Plastic, Rubber
45, 0,0, 0,.75
45, .176776695,0, 0,.75
45, .353553391,0, 0,.75
45, .530330086,0, 0,.75
*ANSI35, ANSI Fire brick, Refractory material
45, 0,0, 0,.25
45, .176776695,0, 0,.25, .3125,-.0625,0,-.0625
*ANSI36, ANSI Marble, Slate, Glass
45, 0,0, .21875,.125, .3125,-.0625,0,-.0625
*ANSI37, ANSI Lead, Zinc, Magnesium, Sound/Heat/Elec Insulation
45, 0,0, 0,.125
135, 0,0, 0,.125
*ANSI38, ANSI Aluminum
45, 0,0, 0,.125
135, 0,0, .25,.125, .3125,-.1875
;;
;;  The following hatch patterns AR-xxxxx
;;  come from AEC/Architectural
;;
*AR-B816, 8x16 Block elevation stretcher bond
0,       0,0,      0,8
90,      0,0,      8,8,                          8,-8
*AR-B816C, 8x16 Block elevation stretcher bond with mortar joints
0,       0,0,      8,8,                         15.625,-.375
0,      -8,.375,   8,8,                         15.625,-.375
90,      0,0,      8,8,                        -8.375,7.625
90,     -0.375,0,  8,8,                        -8.375,7.625
*AR-B88, 8x8 Block elevation stretcher bond
0,       0,0,      0,8
90,      0,0,      8,4,                          8,-8
*AR-BRELM, Standard brick elevation english bond with mortar joints
0,      0,0,       0,5.334,                      7.625,-.375
0,      0,2.25,    0,5.334,                      7.625,-.375
0,      2,2.667,   0,5.334,                      3.625,-.375
0,      2,4.917,   0,5.334,                      3.625,-.375
90,     0,0,       0,8,                          2.25,-3.084
90,    -0.375,0,   0,8,                          2.25,-3.084
90,     2,2.667,   0,4,                          2.25,-3.084
90,     1.625,2.667,  0,4,                       2.25,-3.084
*AR-BRSTD, Standard brick elevation stretcher bond
0,       0,0,      0,2.667
90,      0,0,      2.667,4,                      2.667,-2.667
*AR-CONC, Random dot and stone pattern
50,      0,0,      4.12975034,-5.89789472,       0.75,-8.25
355,     0,0,     -2.03781207,7.37236840,        0.60,-6.6
100.45144446,0.59771681,-0.05229344,5.7305871,-6.9397673,0.63740192,-7.01142112
46.1842, 0,2,      6.19462554,-8.84684596,       1.125,-12.375
96.63563549,.88936745,1.86206693,8.59588239,-10.40964966,0.95610342,-10.5171376
351.18416399,0,2,  7.74327494,11.05855746,       0.9,-9.90000001
21,      1,1.5,    4.12975034,-5.89789472,       0.75,-8.25
326,     1,1.5,   -2.03781207,7.37236840,        0.60,-6.6
71.45144474, 1.49742254,1.16448426, 5.7305871,-6.9397673, 0.6374019,-7.01142112
37.5,    0,0,      2.123,2.567,                  0,-6.52,0,-6.7,0,-6.625
7.5,     0,0,      3.123,3.567,                  0,-3.82,0,-6.37,0,-2.525
-32.5,  -2.23,0,   4.6234,2.678,                 0,-2.5,0,-7.8,0,-10.35
-42.5,  -3.23,0,   3.6234,4.678,                 0,-3.25,0,-5.18,0,-7.35
*AR-HBONE, Standard brick herringbone pattern @ 45 degrees
45,      0,0,      4,4,                          12,-4
135,     2.828427125,2.828427125,  4,-4,         12,-4
*AR-PARQ1, 2x12 Parquet flooring: pattern of 12x12
90,      0,0,      12,12,                        12,-12
90,      2,0,      12,12,                        12,-12
90,      4,0,      12,12,                        12,-12
90,      6,0,      12,12,                        12,-12
90,      8,0,      12,12,                        12,-12
90,     10,0,      12,12,                        12,-12
90,     12,0,      12,12,                        12,-12
0,      0,12,      12,-12,                       12,-12
0,      0,14,      12,-12,                       12,-12
0,      0,16,      12,-12,                       12,-12
0,      0,18,      12,-12,                       12,-12
0,      0,20,      12,-12,                       12,-12
0,      0,22,      12,-12,                       12,-12
0,      0,24,      12,-12,                       12,-12
*AR-RROOF, Roof shingle texture
0, 0,0, 2.2,1, 15,-2,5,-1
0, 1.33,0.5, -1,1.33, 3,-0.33,6,-0.75
0, 0.5,0.85, 5.2,0.67, 8,-1.4,4,-1
*AR-RSHKE, Roof wood shake texture
0,       0,0,      25.5,12,                        6,-5,7,-3,9,-4
0,       6,.5,     25.5,12,                        5,-19,4,-6
0,       18,-.75,  25.5,12,                        3,-31
90,      0,0,      12,8.5,                       11.5,-36.5
90,      6,0,      12,8.5,                       11.25,-36.75
90,      11,0,     12,8.5,                       10.5,-37.5
90,      18,-0.75, 12,8.5,                       11.5,-36.5
90,      21,-0.75, 12,8.5,                       11.5,-36.5
90,      30,0,     12,8.5,                       11,-37
*AR-SAND, Random dot pattern
37.5,   0,0,       1.123,1.567,                  0,-1.52,0,-1.7,0,-1.625
7.5,    0,0,       2.123,2.567,                  0,-.82,0,-1.37,0,-.525
-32.5, -1.23,0,    2.6234,1.678,                 0,-.5,0,-1.8,0,-2.35
-42.5, -1.23,0,    1.6234,2.678,                 0,-.25,0,-1.18,0,-1.35
*BOX, Box steel
90, 0,0, 0,1
90, .25,0, 0,1
0, 0,0, 0,1, -.25,.25
0, 0,.25, 0,1, -.25,.25
0, 0,.5, 0,1, .25,-.25
0, 0,.75, 0,1, .25,-.25
90, .5,0, 0,1, .25,-.25
90, .75,0, 0,1, .25,-.25
*BRASS, Brass material
0, 0,0, 0,.25
0, 0,.125, 0,.25, .125,-.0625
*BRICK, Brick or masonry-type surface
0, 0,0, 0,.25
90, 0,0, 0,.5, .25,-.25
90, .25,0, 0,.5, -.25,.25
*BRSTONE, Brick and stone
0, 0,0, 0,.33
90, .9,0,  .33,.5,    .33,-.33
90, .8,0,  .33,.5,    .33,-.33  
0, .9,.055,  .5,.33,  -.9, .1
0, .9,.11,  .5,.33,  -.9, .1
0, .9,.165,  .5,.33,  -.9, .1
0, .9,.22,  .5,.33,  -.9, .1
0, .9,.275,  .5,.33,  -.9, .1
*CLAY, Clay material
0, 0,0, 0,.1875
0, 0,.03125, 0,.1875
0, 0,.0625, 0,.1875
0, 0,.125, 0,.1875, .1875,-.125
*CORK, Cork material
0, 0,0, 0,.125
135, .0625,-.0625, 0,.35355339, .176776696,-.176776696
135, .09375,-.0625, 0,.35355339, .176776696,-.176776696
135, .125,-.0625, 0,.35355339, .176776696,-.176776696
*CROSS, A series of crosses
0, 0,0, .25,.25, .125,-.375
90, .0625,-.0625, .25,.25, .125,-.375
*DASH, Dashed lines
0, 0,0, .125,.125, .125,-.125
*DOLMIT, Geological rock layering
0, 0,0, 0,.25
45, 0,0, 0,.70710678,.353553390593273762200422181,-.707106781186547524400844362
*DOTS, A series of dots
0, 0,0, .03125,.0625, 0,-.0625
*EARTH, Earth or ground (subterranean)
0, 0,0, .25,.25, .25,-.25
0, 0,.09375, .25,.25, .25,-.25
0, 0,.1875, .25,.25, .25,-.25
90, .03125,.21875, .25,.25, .25,-.25
90, .125,.21875, .25,.25, .25,-.25
90, .21875,.21875, .25,.25, .25,-.25
*ESCHER, Escher pattern
60, 0,0, -.6,1.039230484, 1.1,-.1
180, 0,0, -.6,1.039230484, 1.1,-.1
300, 0,0, .6,1.039230484, 1.1,-.1
60, .1,0, -.6,1.039230484, .2,-1
300, .1,0, .6,1.039230484, .2,-1
60, -.05,.08660254, -.6,1.039230484, .2,-1
180, -.05,.08660254, -.6,1.039230484, .2,-1
300, -.05,-.08660254, .6,1.039230484, .2,-1
180, -.05,-.08660254, -.6,1.039230484, .2,-1
60, -.4,0, -.6,1.039230484, .2,-1
300, -.4,0, .6,1.039230484, .2,-1
60, .2,-.346410161, -.6,1.039230484, .2,-1
180, .2,-.346410161, -.6,1.039230484, .2,-1
300, .2,.346410161, .6,1.039230484, .2,-1
180, .2,.346410161, -.6,1.039230484, .2,-1
0, .2,.173205081, -.6,1.039230484, .7,-.5
0, .2,-.173205081, -.6,1.039230484, .7,-.5
120, .05,.259807621, .6,1.039230484, .7,-.5
120, -.25,.08660254, .6,1.039230484, .7,-.5
240, -.25,-.08660254, .6,1.039230484, .7,-.5
240, .05,-.259807621, .6,1.039230484, .7,-.5
*FLEX, Flexible material
0, 0,0, 0,.25, .25,-.25
45, .25,0, .176776695296,.176776695296, .0625,-.2285533906,.0625,-.353553390593
*GOST_GLASS,glass material
45, 0, 0, 6, -6, 5, -7
45, 2.121320, 0, 6, -6, 2, -10
45, 0, 2.121320, 6, -6, 2, -10
*GOST_WOOD,wood material
90, 0, 0, 0, -6, 10, -2
90, 2, -2, 0, -6, 6, -1.5, 3, -1.5
90, 4, -5, 0, -6, 10, -2
*GOST_GROUND,ground
45, 0, 0, 10, -10, 20
45, 3, 0, 10, -10, 20
45, 6, 0, 10, -10, 20
*GRASS, Grass area
90, 0,0, .707106781,.707106781, .1875,-1.226713563
45, 0,0, 0,1, .1875,-.8125
135, 0,0, 0,1, .1875,-.8125
*GRATE, Grated area
0, 0,0, 0,.03125
90, 0,0, 0,.125
*GRAVEL,Gravel pattern
228.012787504,.72,1.0,12.0413651692039,.0743294146632,.134536,-13.3190880470737
184.969740728,.63,.90,-12.0415166747131,.0433148081592,.230868,-22.85592476123
132.510447078,.40,.88,-14.8659418273816,.061429511683,.162788,-16.1160325960997
267.273689006,.01,.63,-20.0249279039043,.0475651493827,.210238,-20.813558041629
292.833654178,0.0,.42,-12.9999095019474,.048507125026,.206155,-20.4093731280883
357.273689006,.08,.23,-20.0249279039043,.0475651493827,.210238,-20.813558041629
37.6942404667,.29,.22,-16.4011800288558,.0359675000664,.278029,-27.524848548916
72.2553283749,.51,.39,23.0867613281116,.0380969659053,.262488,-25.9863214968134
121.429565615,.59,.64,15.2642639131074,.047404546271,.210950,-20.884073109729
175.236358309,.48,.82,-11.0450488205478,.083045479801,.240832,-11.8007625787923
222.397437798,.24,.84,16.2787889313724,.0321080648114,.311448,-30.8333750047949
138.814074834,1.0,.62,9.2190645101588,.0940720868851,.106301,-10.5238448127347
171.469234390,.92,.69,-13.1528534931484,.0494468176315,.202237,-20.021511416157
225.000000000,.72,.72,0.7071067811865,.7071067811865,.141421,-1.2727925623731
203.198590514,.65,.84,-5.3835637472478,.1313064328928,.076158,-7.5396151058639
291.801409486,.58,.81,-3.156820749011,.185695338158,.107703,-5.2774618071345
30.9637565321,.62,.71,3.6014702879928,.1714985851408,.174929,-5.6560228948453
161.565051177,.77,.80,-2.2135943621183,.3162277660138,.126491,-3.0357866601684
16.3895403340,0.0,.81,10.4401539876873,.0564332648047,.177200,-17.5428451466694
70.3461759419,.17,.86,-11.7045066155395,.0672672793901,.148661,-14.717407747319
293.198590514,.77,1.0,-5.3835637472478,.1313064328928,.152315,-7.4634581058639
343.610459666,.83,.86,-10.4401539876873,.0564332648047,.177200,-17.542845146669
339.443954780,0.0,.19,-5.3838927710229,.117041147157,.170880,-8.3731237453175
294.775140569,.16,.13,-12.0828441168135,.0698430296124,.143178,-14.174643063276
66.8014094864,.78,0.0,5.3835637472487,.1313064328552,.152315,-7.4634581058639
17.3540246363,.84,.14,-13.6013396869991,.0596549986364,.167631,-16.59542361424
69.4439547804,.29,0.0, -5.383892771022,.1170411471946,.085440,-8.4585637453175
101.309932474,.72,0.0,4.1184388379018,.1961161351396,.050990,-5.0480295135928
165.963756532,.71,.05,-3.1529631254726,.2425356250323,.206155,-3.9169506256177
186.009005957,.51,.10,-10.0497393137326,.0523423921723,.191050,-18.9139231745428
303.690067526,.62,.62,-2.2188007849008,.2773500981134,.144222,-3.4613292754640
353.157226587,.7,.5,17.1171966955143,.0397150736497,.251794,-24.9275626240283
60.9453959009,.95,.47,-8.0616726575653,.0971285862325,.102956,-10.192674140987
90, 1,.56, 1.000,1.000, .06,-.940
120.256437164,.49,.13,-8.0619364083848,.0719815751411,.138924,-13.7535199894498
48.0127875042,.42,.25,12.0413651692041,.0743294146212,.269072,-13.1845520470737
0, .60, .45, 1, 1, .26,-.74
325.304846469,.86,.45,12.2063917682497,-.063245553253,.158114,-15.653274300842
254.054604099,.99,.36,4.1208169184605,.1373605639542,.145602,-7.1345078892805
207.645975364,.95,.22,21.4708691170287,.0421824539631,.237065,-23.4694741822594
175.426078740,.74,.11,13.0383438432524,.039872611164,.250799,-24.8290734079689
*HEX, Hexagons
0, 0,0, 0,0.21650635094610966169093079268823, .125,-.25
120, 0,0, 0,0.21650635094610966169093079268823, .125,-.25
60, .125,0, 0,0.21650635094610966169093079268823, .125,-.25
*HONEY, Honeycomb pattern
0, 0,0, .1875,0.10825317547305483084546539634412, .125,-.25
120, 0,0, .1875,0.10825317547305483084546539634412, .125,-.25
60, 0,0, .1875,0.10825317547305483084546539634412, -.25,.125
*HOUND, Houndstooth check
0, 0,0, .25,.0625, 1,-.5
90, 0,0, -.25,.0625, 1,-.5
*INSUL, Insulation material
0, 0,0, 0,.375
0, 0,.125, 0,.375, .125,-.125
0, 0,.25, 0,.375, .125,-.125
;;
;;  Hatch Pattern Definition related to ISO/DIS 12011 line types
;;
;;  (Width * 5 = Distance between lines)
;;
;;  The size of the line segments related to the ISO/DIS 12011 linetypes
;;  define the following hatch pattern. 
;;  The pen width of 1 mm is the base of the definition. To use them with
;;  the other ISO/DIS 12011 predefined pen widths, the line has to be scaled
;;  with the appropriate value (e.g. pen width 0,5 mm -> ltscale 0.5).
;;
*ACAD_ISO02W100, dashed line
0, 0,0, 0,5, 12,-3
*ACAD_ISO03W100, dashed space line
0, 0,0, 0,5, 12,-18
*ACAD_ISO04W100, long dashed dotted line
0, 0,0, 0,5, 24,-3,.5,-3
*ACAD_ISO05W100, long dashed double dotted line
0, 0,0, 0,5, 24,-3,.5,-3,.5,-3
*ACAD_ISO06W100, long dashed triplicate dotted line
0, 0,0, 0,5, 24,-3,.5,-3,.5,-6.5
0, 0,0, 0,5, -34,.5,-3
*ACAD_ISO07W100, dotted line
0, 0,0, 0,5, .5,-3
*ACAD_ISO08W100, long dashed short dashed line
0, 0,0, 0,5, 24,-3,6,-3
*ACAD_ISO09W100, long dashed double-short-dashed line
0, 0,0, 0,5, 24,-3,6,-3,6,-3
*ACAD_ISO10W100, dashed dotted line
0, 0,0, 0,5, 12,-3,.5,-3
*ACAD_ISO11W100, double-dashed dotted line
0, 0,0, 0,5, 12,-3,12,-3,.5,-3
*ACAD_ISO12W100, dashed double-dotted line
0, 0,0, 0,5, 12,-3,.5,-3,.5,-3
*ACAD_ISO13W100, double-dashed double-dotted line
0, 0,0, 0,5, 12,-3,12,-3,.5,-6.5
0, 0,0, 0,5, -33.5,.5,-3
*ACAD_ISO14W100, dashed triplicate-dotted line
0, 0,0, 0,5, 12,-3,.5,-3,.5,-6.5
0, 0,0, 0,5, -22,.5,-3
*ACAD_ISO15W100, double-dashed triplicate-dotted line
0, 0,0, 0,5, 12,-3,12,-3,.5,-10
0, 0,0, 0,5, -33.5,.5,-3,.5,-3
;;
;; end of ACAD_ISO hatch pattern definition
;;
*LINE, Parallel horizontal lines
0, 0,0, 0,.125
*MUDST, Mud and sand
0, 0,0, .5,.25, .25,-.25,0,-.25,0,-.25
*NET, Horizontal / vertical grid
0, 0,0, 0,.125
90, 0,0, 0,.125
*NET3, Network pattern 0-60-120
0, 0,0, 0,.125
60, 0,0, 0,.125
120, 0,0, 0,.125
*PLAST, Plastic material
0, 0,0, 0,.25
0, 0,.03125, 0,.25
0, 0,.0625, 0,.25
*PLASTI, Plastic material
0, 0,0, 0,.25
0, 0,.03125, 0,.25
0, 0,.0625, 0,.25
0, 0,.15625, 0,.25
*SACNCR, Concrete
45, 0,0, 0,.09375
45, .066291261,0, 0,.09375, 0,-.09375
*SQUARE,Small aligned squares
0, 0,0, 0,.125, .125,-.125
90, 0,0, 0,.125, .125,-.125
*STARS, Star of David
0, 0,0, 0,.216506351, .125,-.125
60, 0,0, 0,.216506351, .125,-.125
120, .0625,.108253176, 0,.216506351, .125,-.125
*STEEL, Steel material
45, 0,0, 0,.125
45, 0,.0625, 0,.125
*SWAMP, Swampy area
0, 0,0, .5,.866025403, .125,-.875
90, .0625,0, .866025403,.5, .0625,-1.669550806
90, .078125,0, .866025403,.5, .05,-1.682050806
90, .046875,0, .866025403,.5, .05,-1.682050806
60, .09375,0, .5,.866025403, .04,-.96
120, .03125,0, .5,.866025403, .04,-.96
*TRANS, Heat transfer material
0, 0,0, 0,.25
0, 0,.125, 0,.25, .125,-.125
*TRIANG, Equilateral triangles
60, 0,0, .1875,.324759526, .1875,-.1875
120, 0,0, .1875,.324759526, .1875,-.1875
0, -.09375,.162379763, .1875,.324759526, .1875,-.1875
*ZIGZAG, Staircase effect
0, 0,0, .125,.125, .125,-.125
90, .125,0, .125,.125, .125,-.125

;;  
;;  User Defined Hatch Patterns
;;  Add any hatch patterns that you define to this section of
;;  the file to ensure that they migrate properly when
;;  upgrading to a future AutoCAD version.  If duplicate hatch
;;  patterns are found in this file, items in the User Defined
;;  Hatch Patterns section take precedence over patterns that
;;  appear earlier in the file.
;;

*2x2BRICK,Alternate pairs of bricks  CADalyst TIP359 (c) 1988, Watson Kilbourne
0, 0,0, .5,.5, .45,-.05,.2,-.05,.2,-.05
0, 0,.2, .5,.5, .45,-.55
0, 0,.25, .5,.5, .45,-.55
0, 0,.45, .5,.5, .45,-.05,.2,-.05,.2,-.05
90, 0,0, .5,.5, .2,-.05,.2,-.05,.45,-.05
90, .45,0, .5,.5, .2,-.05,.2,-.05,.45,-.05
90, .7,0, .5,.5, .45,-.55
90, .75,0, .5,.5, .45,-.55

*asbestos,roofing
310.2364, 0.000,0.130, 9.219357,0.058722, 0.170294,-16.859093
0.0000, 0.110,0.000, 1.000,1.000, 0.060000,-0.940
49.7636, 0.170,0.000, -9.219357,0.058722, 0.170294,-16.859093
0.0000, 0.280,0.130, 1.000,1.000, 0.050000,-0.950
310.2364, 0.330,0.130, 9.219357,0.058722, 0.170294,-16.859093
0.0000, 0.440,0.000, 1.000,1.000, 0.060000,-0.940
49.7636, 0.500,0.000, -9.219357,0.058722, 0.170294,-16.859093
0.0000, 0.610,0.130, 1.000,1.000, 0.060000,-0.940
310.2364, 0.670,0.130, 9.219357,0.058722, 0.170294,-16.859093
0.0000, 0.780,0.000, 1.000,1.000, 0.050000,-0.950
49.7636, 0.830,0.000, -9.219357,0.058722, 0.170294,-16.859093
0.0000, 0.940,0.130, 1.000,1.000, 0.060000,-0.940
47.4896, 0.000,0.130, 14.865942,0.061430, 0.162788,-16.116032
312.5104, 0.830,0.250, -14.865942,0.061430, 0.162788,-16.116032
47.4896, 0.670,0.130, 14.865942,0.061430, 0.162788,-16.116032
312.5104, 0.500,0.250, -14.865942,0.061430, 0.162788,-16.116032
47.4896, 0.330,0.130, 14.865942,0.061430, 0.162788,-16.116032
312.5104, 0.170,0.250, -14.865942,0.061430, 0.162788,-16.116032
312.5104, 0.170,0.500, -14.865942,0.061430, 0.162788,-16.116032
47.4896, 0.330,0.380, 14.865942,0.061430, 0.162788,-16.116032
312.5104, 0.500,0.500, -14.865942,0.061430, 0.162788,-16.116032
47.4896, 0.670,0.380, 14.865942,0.061430, 0.162788,-16.116032
312.5104, 0.830,0.500, -14.865942,0.061430, 0.162788,-16.116032
47.4896, 0.000,0.380, 14.865942,0.061430, 0.162788,-16.116032
0.0000, 0.940,0.380, 1.000,1.000, 0.060000,-0.940
49.7636, 0.830,0.250, -9.219357,0.058722, 0.170294,-16.859093
0.0000, 0.780,0.250, 1.000,1.000, 0.050000,-0.950
310.2364, 0.670,0.380, 9.219357,0.058722, 0.170294,-16.859093
0.0000, 0.610,0.380, 1.000,1.000, 0.060000,-0.940
49.7636, 0.500,0.250, -9.219357,0.058722, 0.170294,-16.859093
0.0000, 0.440,0.250, 1.000,1.000, 0.060000,-0.940
310.2364, 0.330,0.380, 9.219357,0.058722, 0.170294,-16.859093
0.0000, 0.280,0.380, 1.000,1.000, 0.050000,-0.950
49.7636, 0.170,0.250, -9.219357,0.058722, 0.170294,-16.859093
0.0000, 0.110,0.250, 1.000,1.000, 0.060000,-0.940
310.2364, 0.000,0.380, 9.219357,0.058722, 0.170294,-16.859093
310.2364, 0.170,0.750, 9.219357,0.058722, 0.170294,-16.859093
49.7636, 0.330,0.620, -9.219357,0.058722, 0.170294,-16.859093
310.2364, 0.500,0.750, 9.219357,0.058722, 0.170294,-16.859093
49.7636, 0.670,0.620, -9.219357,0.058722, 0.170294,-16.859093
310.2364, 0.830,0.750, 9.219357,0.058722, 0.170294,-16.859093
49.7636, 0.000,0.620, -9.219357,0.058722, 0.170294,-16.859093
0.0000, 0.940,0.620, 1.000,1.000, 0.060000,-0.940
47.4896, 0.830,0.500, 14.865942,0.061430, 0.162788,-16.116032
0.0000, 0.780,0.500, 1.000,1.000, 0.050000,-0.950

*batt, Batt insulation
161.57,1,1,7.59,2.53,-56.92,6.32
18.43,-1,1,-7.59,2.53,-56.92,6.32
108.43,1,1,-20.24,2.53,18.97,-44.27
71.57,-1,1,20.24,2.53,18.97,-44.27

*block,CINDER BLOCK
0.0000, 0.030,0.030, 1.000,1.000, 0.450000,-0.550
90.0000, 0.480,0.030, 1.000,1.000, 0.200000,-0.800
180.0000, 0.480,0.230, 1.000,1.000, 0.450000,-0.550
270.0000, 0.030,0.230, 1.000,1.000, 0.200000,-0.800
270.0000, 0.030,0.730, 1.000,1.000, 0.200000,-0.800
180.0000, 0.480,0.730, 1.000,1.000, 0.450000,-0.550
90.0000, 0.480,0.530, 1.000,1.000, 0.200000,-0.800
0.0000, 0.030,0.530, 1.000,1.000, 0.450000,-0.550
270.0000, 0.530,0.230, 1.000,1.000, 0.200000,-0.800
180.0000, 0.980,0.230, 1.000,1.000, 0.450000,-0.550
90.0000, 0.980,0.030, 1.000,1.000, 0.200000,-0.800
0.0000, 0.530,0.030, 1.000,1.000, 0.450000,-0.550
270.0000, 0.530,0.730, 1.000,1.000, 0.200000,-0.800
180.0000, 0.980,0.730, 1.000,1.000, 0.450000,-0.550
90.0000, 0.980,0.530, 1.000,1.000, 0.200000,-0.800
0.0000, 0.530,0.530, 1.000,1.000, 0.450000,-0.550
0.0000, 0.280,0.780, 1.000,1.000, 0.450000,-0.550
90.0000, 0.730,0.780, 1.000,1.000, 0.200000,-0.800
180.0000, 0.730,0.980, 1.000,1.000, 0.450000,-0.550
270.0000, 0.280,0.980, 1.000,1.000, 0.200000,-0.800
0.0000, 0.000,0.980, 1.000,1.000, 0.230000,-0.770
270.0000, 0.230,0.980, 1.000,1.000, 0.200000,-0.800
180.0000, 0.230,0.780, 1.000,1.000, 0.230000,-0.770
180.0000, 1.000,0.980, 1.000,1.000, 0.220000,-0.780
270.0000, 0.780,0.980, 1.000,1.000, 0.200000,-0.800
0.0000, 0.780,0.780, 1.000,1.000, 0.220000,-0.780
0.0000, 0.780,0.280, 1.000,1.000, 0.220000,-0.780
270.0000, 0.780,0.480, 1.000,1.000, 0.200000,-0.800
180.0000, 1.000,0.480, 1.000,1.000, 0.220000,-0.780
180.0000, 0.230,0.280, 1.000,1.000, 0.230000,-0.770
270.0000, 0.230,0.480, 1.000,1.000, 0.200000,-0.800
0.0000, 0.000,0.480, 1.000,1.000, 0.230000,-0.770
270.0000, 0.280,0.480, 1.000,1.000, 0.200000,-0.800
180.0000, 0.730,0.480, 1.000,1.000, 0.450000,-0.550
90.0000, 0.730,0.280, 1.000,1.000, 0.200000,-0.800
0.0000, 0.280,0.280, 1.000,1.000, 0.450000,-0.550

*chkdl, checked plate  CADalyst TIP559 (c)1990, Stan H. Bimson
45, 0,0, 1.76776695,1.76776695, .26516504,-1.50260191
0, .1875,.1875, 1.25,1.25, .625,-1.875
315, .8125,.1875, 1.76776695,1.76776695, .26516504,-1.50260191
225, 1,0, 1.76776695,1.76776695, .26516504,-1.50260191
0, .1875,-.1875, 1.25,1.25, .625,-1.875
315, 0,0, 1.76776695,1.76776695, .26516504,-1.50260191
90, 1.5625,-.3125, 1.25,1.25, .625,-1.875
45, 1.5625,.3125, 1.76776695,1.76776695, .26516504,-1.50260191
45, 1.75,-.5, 1.76776695,1.76776695, .26516504,-1.50260191
90, 1.9375,-.3125, 1.25,1.25, .625,-1.875
315, 1.5625,-.3125, 1.76776695,1.76776695, .26516504,-1.50260191
315, 1.75,.5, 1.76776695,1.76776695, .26516504,-1.50260191

*chkds, checked plate  CADalyst TIP557 (c)1990, Stan H. Bimson
0, 0,0, 1.25,1.25, 1,-1.5
90, 1.75,-.5, 1.25,1.25, 1,-1.5

*conc,CONCRETE
0, 0.950,0.640, 0,1, 0,-1
0, 0.960,0.290, 0,1, 0,-1
0, 0.990,0.830, 0,1, 0,-1
338.1986, 0.470,0.520, 3.156821,0.185695, 0.107703,-5.277462
216.8699, 0.570,0.480, -3.600000,0.200000, 0.050000,-4.950000
130.6013, 0.530,0.450, -7.809496,0.108465, 0.092195,-9.127349
206.5651, 0.200,0.330, 1.341641,0.447214, 0.022361,-2.213707
326.3099, 0.180,0.320, 2.218801,0.277350, 0.036056,-3.569496
108.4349, 0.210,0.300, 2.213594,0.316228, 0.031623,-3.130655
225.0000, 0.840,0.230, 0.707107,0.707107, 0.042426,-1.371787
0.0000, 0.810,0.200, 1.000,1.000, 0.060000,-0.940
135.0000, 0.870,0.200, 0.707107,0.707107, 0.042426,-1.371787
251.5651, 0.720,0.870, -2.213594,0.316228, 0.031623,-3.130655
0.0000, 0.710,0.840, 1.000,1.000, 0.050000,-0.950
143.1301, 0.760,0.840, 3.600000,0.200000, 0.050000,-4.950000
213.6901, 0.190,0.880, -2.218801,0.277350, 0.036056,-3.569496
341.5651, 0.160,0.860, -2.213594,0.316228, 0.063246,-3.099032
126.8699, 0.220,0.840, -3.600000,0.200000, 0.050000,-4.950000
0, 0.480,0.840, 0,1, 0,-1
0, 0.210,0.580, 0,1, 0,-1
0, 0.490,0.210, 0,1, 0,-1
0, 0.760,0.520, 0,1, 0,-1
0, 0.470,0.690, 0,1, 0,-1
0, 0.250,0.720, 0,1, 0,-1
0, 0.340,0.660, 0,1, 0,-1
0, 0.300,0.420, 0,1, 0,-1
0, 0.060,0.460, 0,1, 0,-1
0, 0.070,0.690, 0,1, 0,-1
0, 0.040,0.910, 0,1, 0,-1
0, 0.350,0.950, 0,1, 0,-1
0, 0.570,0.990, 0,1, 0,-1
0, 0.920,0.950, 0,1, 0,-1
0, 0.680,0.640, 0,1, 0,-1
0, 0.580,0.820, 0,1, 0,-1
0, 0.660,0.340, 0,1, 0,-1
0, 0.360,0.290, 0,1, 0,-1
0, 0.660,0.070, 0,1, 0,-1
0, 0.330,0.130, 0,1, 0,-1
0, 0.010,0.100, 0,1, 0,-1
0, 0.130,0.050, 0,1, 0,-1
0, 0.140,0.190, 0,1, 0,-1
0, 0.810,0.030, 0,1, 0,-1
0, 0.930,0.440, 0,1, 0,-1
0, 0.880,0.740, 0,1, 0,-1
0, 0.420,0.020, 0,1, 0,-1

*concret2, Concrete pattern
   45, 1,1, 3,3, .14142136,-2.0506097, 0,-2.0506097
   45, 1.2309698,.9043293, 3,3, .14142136,-2.0506097, 0,-2.0506097
337.5, 1.1,1.1, 1.6235883,-3.9196889, .25,-1.4985883, 0,-1.495883
337.5, 1,1, 1.6235883,-3.9196889, .25,-1.4985883, 0,-1.495883
   60, 0,0, 2,3.4641016, .1875,-1.90625, 0,-1.90625
  120, 0,0, 2,3.4641016, .1875,-1.90625, 0,-1.90625
    0, -.09375,.1623797, 2,3.4641016, .1875,-1.906250, 0,-1.90625

*CONCRETE, random dot and stone pattern
50,      0,0,      4.12975034,-5.89789472,       0.75,-8.25
355,     0,0,     -2.03781207,7.37236840,        0.60,-6.6
100.4514, 0.5977168,-0.0522934, 5.7305871,-6.9397673, 0.6374019,-7.01142112
46.1842, 0,2,      6.19462551,-8.84684208,       1.125,-12.375
96.6356, 0.88936745,1.86206693, 8.59588071,-10.40965104, 0.95610288,-10.51713
351.1842, 0,2,     7.74328189,11.0585526,        0.9,-9.9
21,      1,1.5,    4.12975034,-5.89789472,       0.75,-8.25
326,     1,1.5,   -2.03781207,7.37236840,        0.60,-6.6
71.4514, 1.49742233,1.16448394, 5.7305871,-6.9397673, 0.6374019,-7.01142112
37.5,    0,0,      2.123,2.567,                  0,-6.52,0,-6.7,0,-6.625
7.5,     0,0,      3.123,3.567,                  0,-3.82,0,-6.37,0,-2.525
-32.5,  -2.23,0,   4.6234,2.678,                 0,-2.5,0,-7.8,0,-10.35
-42.5,  -3.23,0,   3.6234,4.678,                 0,-3.25,0,-5.18,0,-7.35

*concrt,Fine Concrete   CADalyst TIP414 (c)1989, Watson Kilbourne
0, 0,.05, 1,1, .05,-.35,0,-.5,0,-.1
0, 0,.35, 1,1, 0,-.35,.05,-.5,0,-.1
0, 0,.55, 1,1, 0,-.4,0,-.45,.05,-.1
0, 0,.95, 1,1, 0,-.4,.05,-.45,0,-.1
90, 0,0, 1,1, .05,-.95
90, .4,0, 1,1, -.35,.05,-.3,0,-.25,.05
90, .9,0, 1,1, 0,-.5,.05,-.25,0,-.2
90, .1,0, .5,.5, 0,-.15,0,-.15,0,-.2
90, .2,.05, .5,.5, 0,-.2,0,-.15,0,-.15
90, .3,0, .5,.5, 0,-.2,0,-.2,0,-.1
90, .5,.1, .5,.5, 0,-.15,0,-.2,0,-.15
45, 0,0, .70710678,.70710678, .07071,-.424264,.07071,-.84852956
135, .4,0, .70710678,-.70710678, -.7071,.07071,-.56569356,.07071

*diatread,Diamond Tread Plate  (c)1990 Watson Kilbourne
18.43494882,  .9,.7,  1.264911064,.632455532, .632455532,-2.529822128
71.56505118,  .5,.1, -1.264911064,.632455532, .632455532,-2.529822128
71.56505118,  .3,.7, -1.264911064,.632455532, .632455532,-2.529822128
108.43494882, .5,.1,  1.264911064,.632455532, .632455532,-2.529822128
108.43494882, .7,.7,  1.264911064,.632455532, .632455532,-2.529822128
161.56505118, .1,.7, -1.264911064,.632455532, .632455532,-2.529822128
198.43494882, .1,.7,  1.264911064,.632455532, .632455532,-2.529822128
341.56505118, .9,.7, -1.264911064,.632455532, .632455532,-2.529822128

*exm,expanded metal
153.4349, 1.000,0.900, -1.341641,0.447214, 0.223607,-2.012461
26.5651, 0.300,0.830, 1.341641,0.447214, 0.223607,-2.012461
0.0000, 0.500,0.930, 1.000,1.000, 0.200000,-0.800
333.4349, 0.700,0.930, -1.341641,0.447214, 0.223607,-2.012461
206.5651, 0.900,0.830, 1.341641,0.447214, 0.223607,-2.012461
180.0000, 0.700,0.730, 1.000,1.000, 0.200000,-0.800
153.4349, 0.500,0.730, -1.341641,0.447214, 0.223607,-2.012461
26.5651, 0.800,0.670, 1.341641,0.447214, 0.223607,-2.012461
153.4349, 1.000,0.570, -1.341641,0.447214, 0.223607,-2.012461
26.5651, 0.300,0.500, 1.341641,0.447214, 0.223607,-2.012461
0.0000, 0.500,0.600, 1.000,1.000, 0.200000,-0.800
333.4349, 0.700,0.600, -1.341641,0.447214, 0.223607,-2.012461
206.5651, 0.900,0.500, 1.341641,0.447214, 0.223607,-2.012461
180.0000, 0.700,0.400, 1.000,1.000, 0.200000,-0.800
153.4349, 0.500,0.400, -1.341641,0.447214, 0.223607,-2.012461
26.5651, 0.800,0.330, 1.341641,0.447214, 0.223607,-2.012461
153.4349, 1.000,0.230, -1.341641,0.447214, 0.223607,-2.012461
26.5651, 0.800,0.000, 1.341641,0.447214, 0.223607,-2.012461
26.5651, 0.300,0.170, 1.341641,0.447214, 0.223607,-2.012461
0.0000, 0.500,0.270, 1.000,1.000, 0.200000,-0.800
333.4349, 0.700,0.270, -1.341641,0.447214, 0.223607,-2.012461
206.5651, 0.900,0.170, 1.341641,0.447214, 0.223607,-2.012461
180.0000, 0.700,0.070, 1.000,1.000, 0.200000,-0.800
153.4349, 0.500,0.070, -1.341641,0.447214, 0.223607,-2.012461
0.0000, 0.000,0.100, 1.000,1.000, 0.200000,-0.800
333.4349, 0.200,0.100, -1.341641,0.447214, 0.223607,-2.012461
0.0000, 0.000,0.430, 1.000,1.000, 0.200000,-0.800
333.4349, 0.200,0.430, -1.341641,0.447214, 0.223607,-2.012461
206.5651, 0.400,0.330, 1.341641,0.447214, 0.223607,-2.012461
180.0000, 0.200,0.230, 1.000,1.000, 0.200000,-0.800
0.0000, 0.000,0.770, 1.000,1.000, 0.200000,-0.800
333.4349, 0.200,0.770, -1.341641,0.447214, 0.223607,-2.012461
206.5651, 0.400,0.670, 1.341641,0.447214, 0.223607,-2.012461
180.0000, 0.200,0.570, 1.000,1.000, 0.200000,-0.800
206.5651, 0.400,1.000, 1.341641,0.447214, 0.223607,-2.012461
180.0000, 0.200,0.900, 1.000,1.000, 0.200000,-0.800

*expand,EXPANDED METAL
 30,0,0,.3,.519615242,.5,-.1
-30,0,0,.3,.519615242,.5,-.1
-30,.4330,.250,.3,.519615242,.5,-.1
 30,.4330,.350,.3,.519615242,.5,-.1

*patio1,octogons and squares
45.0000, 0.400,0.400, 0.707107,0.707107, 0.141421,-1.272792
180.0000, 0.400,0.400, 1.000,1.000, 0.400000,-0.600
270.0000, 0.400,0.400, 1.000,1.000, 0.400000,-0.600
0.0000, 0.500,0.500, 1.000,1.000, 0.400000,-0.600
315.0000, 0.900,0.500, -0.707107,0.707107, 0.141421,-1.272792
90.0000, 0.500,0.500, 1.000,1.000, 0.400000,-0.600
135.0000, 0.500,0.900, 0.707107,0.707107, 0.141421,-1.272792
0.0000, 0.500,0.900, 1.000,1.000, 0.400000,-0.600
45.0000, 0.900,0.900, 0.707107,0.707107, 0.141421,-1.272792
270.0000, 0.900,0.900, 1.000,1.000, 0.400000,-0.600
270.0000, 1.000,0.400, 1.000,1.000, 0.400000,-0.600
180.0000, 0.400,1.000, 1.000,1.000, 0.400000,-0.600

*patio3,skewed brick
243.4349, 0.200,1.000, -1.341641,0.447214, 0.335410,-1.900658
153.4349, 0.400,0.900, -1.341641,0.447214, 0.223607,-2.012461
153.4349, 0.650,0.900, -1.341641,0.447214, 0.223607,-2.012461
243.4349, 0.450,1.000, -1.341641,0.447214, 0.111803,-2.124265
153.4349, 0.900,0.900, -1.341641,0.447214, 0.223607,-2.012461
243.4349, 0.700,1.000, -1.341641,0.447214, 0.223607,-2.012461
158.1986, 1.000,0.980, 3.156821,0.185695, 0.053852,-5.331313
243.4349, 0.950,1.000, -1.341641,0.447214, 0.111803,-2.124265
154.9831, 1.000,0.730, 14.317694,0.060412, 0.165529,-16.387416
63.4349, 0.700,0.500, -1.341641,0.447214, 0.335410,-1.900658
153.4349, 0.800,0.700, -1.341641,0.447214, 0.223607,-2.012461
63.4349, 0.450,0.500, -1.341641,0.447214, 0.111803,-2.124265
153.4349, 0.550,0.700, -1.341641,0.447214, 0.223607,-2.012461
153.4349, 0.300,0.700, -1.341641,0.447214, 0.223607,-2.012461
63.4349, 0.200,0.500, -1.341641,0.447214, 0.335410,-1.900658
63.4349, 0.850,0.300, -1.341641,0.447214, 0.335410,-1.900658
153.4349, 0.950,0.500, -1.341641,0.447214, 0.223607,-2.012461
153.4349, 0.700,0.500, -1.341641,0.447214, 0.223607,-2.012461
63.4349, 0.350,0.300, -1.341641,0.447214, 0.223607,-2.012461
153.4349, 0.450,0.500, -1.341641,0.447214, 0.223607,-2.012461
153.4349, 0.200,0.500, -1.341641,0.447214, 0.223607,-2.012461
63.4349, 0.000,0.100, -1.341641,0.447214, 0.335410,-1.900658
153.4349, 1.000,0.350, -1.341641,0.447214, 0.111803,-2.124265
153.4349, 0.850,0.300, -1.341641,0.447214, 0.223607,-2.012461
153.4349, 0.600,0.300, -1.341641,0.447214, 0.223607,-2.012461
153.4349, 0.350,0.300, -1.341641,0.447214, 0.223607,-2.012461
153.4349, 0.100,0.300, -1.341641,0.447214, 0.111803,-2.124265
153.4349, 1.000,0.100, -1.341641,0.447214, 0.223607,-2.012461
63.4349, 0.700,0.000, -1.341641,0.447214, 0.223607,-2.012461
153.4349, 0.750,0.100, -1.341641,0.447214, 0.223607,-2.012461
243.4349, 0.300,0.200, -1.341641,0.447214, 0.223607,-2.012461
153.4349, 0.500,0.100, -1.341641,0.447214, 0.223607,-2.012461
153.4349, 0.250,0.100, -1.341641,0.447214, 0.223607,-2.012461
154.9831, 0.150,0.900, 14.317694,0.060412, 0.165529,-16.387416
158.1986, 0.050,0.700, 3.156821,0.185695, 0.053852,-5.331313
243.4349, 0.650,0.400, -1.341641,0.447214, 0.335410,-1.900658
63.4349, 0.550,0.700, -1.341641,0.447214, 0.111803,-2.124265

*patio4,flag stone
270.0000, 0.530,0.700, 1.000,1.000, 0.270000,-0.730
180.0000, 0.580,0.700, 1.000,1.000, 0.580000,-0.420
0.0000, 0.000,0.900, 1.000,1.000, 0.580000,-0.420
0.0000, 0.580,0.830, 1.000,1.000, 0.370000,-0.630
90.0000, 0.750,0.830, 1.000,1.000, 0.170000,-0.830
0.0000, 0.530,0.550, 1.000,1.000, 0.470000,-0.530
180.0000, 0.750,0.050, 1.000,1.000, 0.170000,-0.830
270.0000, 0.950,0.900, 1.000,1.000, 0.350000,-0.650
0.0000, 0.950,0.700, 1.000,1.000, 0.050000,-0.950
270.0000, 0.780,0.550, 1.000,1.000, 0.450000,-0.550
0.0000, 0.000,0.550, 1.000,1.000, 0.230000,-0.770
270.0000, 0.230,0.700, 1.000,1.000, 0.280000,-0.720
180.9548, 0.780,0.430, 59.008472,0.016664, 0.600083,-59.408249
180.0000, 1.000,0.900, 1.000,1.000, 0.250000,-0.750
180.0000, 1.000,0.100, 1.000,1.000, 0.250000,-0.750
270.0000, 0.750,0.170, 1.000,1.000, 0.170000,-0.830
0.0000, 0.000,0.100, 1.000,1.000, 0.330000,-0.670
273.3665, 0.320,0.170, 16.031112,0.058722, 0.170294,-16.859093
90.0000, 0.120,0.550, 1.000,1.000, 0.150000,-0.850
180.0000, 1.000,0.350, 1.000,1.000, 0.220000,-0.780
0.0000, 0.000,0.350, 1.000,1.000, 0.180000,-0.820
0.0000, 0.180,0.180, 1.000,1.000, 0.600000,-0.400
90.0000, 0.330,0.900, 1.000,1.000, 0.100000,-0.900
0.0000, 0.530,0.650, 1.000,1.000, 0.420000,-0.580
0.0000, 0.230,0.600, 1.000,1.000, 0.300000,-0.700
270.0000, 0.180,0.420, 1.000,1.000, 0.240000,-0.760
262.8750, 0.230,0.180, -7.069980,0.124035, 0.080623,-7.981635
90.0000, 0.580,0.700, 1.000,1.000, 0.300000,-0.700
270.0000, 0.580,0.180, 1.000,1.000, 0.180000,-0.820

*pavingbr,Paving Bricks - TIP 319 (c)1988, Watson Kilbourne
0,  0,   0, .25, .25,.45, -.3,  .2,-.05
0,  0,  .2, .25, .25,.45,-.05,  .2, -.3
90, 0,   0,-.25, .25, .2,-.05, .45, -.3
90,.2,-.05, .25,-.25,-.3, .45,-.05,  .2

*RIPRAP,Stone Riprap pattern (c)1992 Dan Senne
0, .5,.85,0,1,0,-1
0, .9,.85,0,1,0,-1
0, .65,.61,0,1,0,-1
0, .2,.61,0,1,0,-1
0, .65,.25,0,1,0,-1
0, .65,.05,0,1,0,-1
0, .2,.05,0,1,0,-1
0, .3803, .688598,0,1,.052965,-.947035
0, .608952,.795519,0,1,.113584,-.886416
0, .08702,.039023,0,1,.023094,-.976906
0, .716344,.174581,0,1,.067651,-.932349
0, .831315,.233758,0,1,.083689,-.916311
0, .87398,.376982,0,1,0.057077,-.942923
0, .247789,.9421,0,1,.036035,-.3465,.039129,-.5783
0, .185472,.666245,0,1,.068395,-.1854,.043295,-.703
0, .307999,.720376,0,1,.020862,-.5292,.043139,-.4068
0, .54923,0.302487,0,1,.149237,-.1958,.040809,-.6141
0, .275084,.063556,0,1,.060274,-.5951,.027896,-.3167
0, .763475,.741618,0,1,.07334,-.926660
0, .671134,.955525,0,1,.064887,-.935113
0, .397927,.579484,0,1,.061086,-.0475,.087204,-.8042
0, .164872,.968949,0,1,.056067,-.943933
0, .122998,.456739,0,1,.018134,-.981866
0, .096525,.620137,0,1,.033750,-.96625
0, .757779,.019173,0,1,.128343,-.871657
0, .664554,.508636,0,1,.052734,-.054,.133317,-.7599
0, .206722,.482339,0,1,.087891,-.912109
45, .859254,.362256,.707107,.707107,.020826,-1.393388
45, .904616,.508636,.707107,.707107,.082650,-1.331564
45, .141133,.456739,.707107,.707107,.071269,-1.342944
45, .253868,.666245,.707107,.707107,.082507,-1.331707
45, .328861,.720376,.707107,.707107,.039456,-1.374758
45, .334536,.642875,.707107,.707107,.064661,-1.349552
45, .698467,.302487,.707107,.707107,.109359,-1.304854
45, .772137,.174581,.707107,.707107,.083689,-1.330524
45, .696618,.154855,.707107,.707107,.027896,-1.386317
45, .487919,.091938,.707107,.707107,.089648,-1.324565
45, .335359,.063556,.707107,.707107,.119701,-1.294513
45, .110114,.039023,.707107,.707107,.049438,-1.364775
45, .722536,.795519,.707107,.707107,.075321,-1.338892
45, .05,0.122983,.707107,.707107,.076275,-.447,.12223,-.7695
45, .935094,.302487,.707107,.707107,.039548,-1.374666
45, .576169,.887928,.707107,.707107,.07661,-1.337603
45, .657709,.9421,.707107,.707107,.018985,-1.395228
45, .696618,.674761,.707107,.707107,.09455,-1.319664
45, .459013,.579484,.707107,.707107,.077970,-1.336244
45, .070344,.87442,.707107,.707107,.133684,-1.28053
45, .05,0.573612,.707107,.707107,.065796,-1.348418
45, .549692,.030165,.707107,.707107,.037444,-1.376769
45, .958401,.063556,.707107,.707107,.050214,-1.364
45, .886121,.019173,.707107,.707107,.081763,-1.33245
45, .145073,.42069,.707107,.707107,.087185,-1.327029
45, .070344,.327108,.707107,.707107,.105683,-1.308531
90, .145073,.073982,0,1,.061798,-.938202
90, .775796,.379816,0,1,.070313,-.929688
90, .070344,.268296,0,1,.058812,-.4911,.05625,-.3939
90, .775796,.848779,0,1,.066971,-.933029
90, .191528,.507134,0,1,.051750,-.948250
90, .963058,.330451,0,1,.01453,-.2221,.0914,-.6719
90, .696618,.080333,0,1,.074522,-.4285,.0914,-.4056
90, .42,.148197,0,1,.138442,-.1627,.0437,-.6552
90, .35676,.349879,0,1,.070313,-.3281,.120888,-.48
90, .145073,.397474,0,1,.023217,-.976783
90, .859254,.337517,0,1,.024738,-.975262
90, .08864,.763077,0,1,.036797,-.963203
90, .04999,.076044,0,1,.046939,-.408,.043875,-.5024
90, .576169,.056642,0,1,.073828,-.6978,.0597,-.1687
90, .993907,.099062,0,1,.055793,-.944207
90, .474652,.377065,0,1,.017578,-.982422
135, .397927,.579484,.707107,.707107,.089648,-1.324565
135, .455576,.666245,.707107,.707107,.031612,-1.382601
135, .872685,.705748,.707107,.707107,.050727,-1.363487
135, .257171,.932718,.707107,.707107,.051238,-1.362975
135, .35676,.869164,.707107,.707107,.103147,-1.311066
135, .775796,.91575,.707107,.707107,.05625,-1.357964
135, .963058,.658514,.707107,.707107,.087487,-1.326727
135, .771299,.508636,.707107,.707107,.105614,-1.308599
135, .664554,.508636,.707107,.707107,.100195,-1.314018
135, .775796,.450128,.707107,.707107,.082742,-1.331471
135, .993907,.154855,.707107,.707107,.111586,-1.302628
135, .757779,.019173,.707107,.707107,.086493,-1.327720
135, .576169,.13047,.707107,.707107,.035156,-1.379057
135, .549692,.030165,.707107,.707107,.087361,-1.326853
135, .185472,.666245,.707107,.707107,.136941,-1.277272
135, .191528,.558884,.707107,.707107,.086625,-1.327589
135, .122998,.456739,.707107,.707107,.103235,-1.310978
135, .35676,.420191,.707107,.707107,.087891,-1.326323
135, .42,.286639,.707107,.707107,.089435,-1.324779
135, .275084,.063556,.707107,.707107,.289547,-1.124667
135, .145073,.13578,.707107,.707107,.058178,-1.356036
135, .08702,.039023,.707107,.707107,.052355,-1.361859
135, .894284,.302487,.707107,.707107,.049540,-1.364673
135, .963058,.344981,.707107,.707107,.045256,-1.368957
135, .514145,.634617,.707107,.707107,.044728,-1.369486
135, .608952,.795519,.707107,.707107,.046362,-1.367851
135, .098102,.790413,.707107,.707107,.039255,-1.374958
135, .487805,.38149,.707107,.707107,.095891,-1.318322
135, .54923,.302487,.707107,.707107,.105469,-1.308745

*Screen,window screen
270.0000, 0.500,1.000, 1.000,1.000, 0.370000,-0.630
90.0000, 0.500,0.000, 1.000,1.000, 0.370000,-0.630
270.0000, 0.000,0.880, 1.000,1.000, 0.760000,-0.240
0.0000, 0.120,0.500, 1.000,1.000, 0.760000,-0.240
0.0000, 0.000,1.000, 1.000,1.000, 0.370000,-0.630
0.0000, 0.630,1.000, 1.000,1.000, 0.370000,-0.630

*splitface, mit AHatch Pro erzeugt
63.434949,0.200000,4.600000,8.765386,4.382693,0.223607,-10.733126
63.434949,0.200000,9.500000,8.765386,4.382693,0.223607,-10.733126
63.434949,0.100000,4.400000,8.765386,4.382693,0.223607,-10.733126
63.434949,0.100000,9.300000,8.765386,4.382693,0.223607,-10.733126
90.000000,0.100000,4.000000,0.000000,4.900000,0.400000,-4.500000
90.000000,0.100000,3.800000,0.000000,4.900000,0.200000,-4.700000
0.000000,0.100000,3.800000,0.000000,4.900000,0.400000,-4.500000
18.434949,0.500000,3.800000,1.549516,4.648548,0.316228,-15.178933
18.434949,0.500000,8.700000,1.549516,4.648548,0.316228,-15.178933
18.434949,5.400000,3.800000,1.549516,4.648548,0.316228,-15.178933
18.434949,5.400000,8.700000,1.549516,4.648548,0.316228,-15.178933
18.434949,10.300000,3.800000,1.549516,4.648548,0.316228,-15.178933
18.434949,10.300000,8.700000,1.549516,4.648548,0.316228,-15.178933
33.690068,0.800000,3.900000,5.436062,8.154093,0.360555,-17.306646
33.690068,0.800000,8.800000,5.436062,8.154093,0.360555,-17.306646
33.690068,0.800000,13.700000,5.436062,8.154093,0.360555,-17.306646
33.690068,5.700000,3.900000,5.436062,8.154093,0.360555,-17.306646
33.690068,5.700000,8.800000,5.436062,8.154093,0.360555,-17.306646
33.690068,5.700000,13.700000,5.436062,8.154093,0.360555,-17.306646
33.690068,10.600000,3.900000,5.436062,8.154093,0.360555,-17.306646
33.690068,10.600000,8.800000,5.436062,8.154093,0.360555,-17.306646
33.690068,10.600000,13.700000,5.436062,8.154093,0.360555,-17.306646
63.434949,1.100000,4.100000,8.765386,4.382693,0.223607,-10.733126
63.434949,1.100000,9.000000,8.765386,4.382693,0.223607,-10.733126
90.000000,1.200000,4.300000,0.000000,4.900000,0.200000,-4.700000
90.000000,1.200000,4.500000,0.000000,4.900000,0.200000,-4.700000
-26.565051,1.000000,4.800000,8.765386,4.382693,0.223607,-10.733126
-26.565051,1.000000,9.700000,8.765386,4.382693,0.223607,-10.733126
-26.565051,5.900000,4.800000,8.765386,4.382693,0.223607,-10.733126
-26.565051,5.900000,9.700000,8.765386,4.382693,0.223607,-10.733126
-26.565051,0.800000,4.900000,8.765386,4.382693,0.223607,-10.733126
-26.565051,0.800000,9.800000,8.765386,4.382693,0.223607,-10.733126
-26.565051,5.700000,4.900000,8.765386,4.382693,0.223607,-10.733126
-26.565051,5.700000,9.800000,8.765386,4.382693,0.223607,-10.733126
0.000000,0.400000,4.900000,0.000000,4.900000,0.400000,-4.500000
45.000000,0.300000,4.800000,3.464823,3.464823,0.141421,-6.788225
45.000000,0.300000,9.700000,3.464823,3.464823,0.141421,-6.788225
63.434949,1.400000,4.700000,8.765386,4.382693,0.223607,-10.733126
63.434949,1.400000,9.600000,8.765386,4.382693,0.223607,-10.733126
90.000000,1.400000,4.600000,0.000000,4.900000,0.100000,-4.800000
63.434949,1.300000,4.400000,8.765386,4.382693,0.223607,-10.733126
63.434949,1.300000,9.300000,8.765386,4.382693,0.223607,-10.733126
90.000000,1.300000,4.200000,0.000000,4.900000,0.200000,-4.700000
45.000000,1.200000,4.100000,3.464823,3.464823,0.141421,-6.788225
45.000000,1.200000,9.000000,3.464823,3.464823,0.141421,-6.788225
45.000000,1.100000,4.000000,3.464823,3.464823,0.141421,-6.788225
45.000000,1.100000,8.900000,3.464823,3.464823,0.141421,-6.788225
71.565051,1.000000,3.700000,13.945644,4.648548,0.316228,-15.178933
71.565051,1.000000,8.600000,13.945644,4.648548,0.316228,-15.178933
71.565051,1.000000,13.500000,13.945644,4.648548,0.316228,-15.178933
-18.434949,1.000000,3.700000,13.945644,4.648548,0.316228,-15.178933
-18.434949,1.000000,8.600000,13.945644,4.648548,0.316228,-15.178933
-18.434949,5.900000,3.700000,13.945644,4.648548,0.316228,-15.178933
-18.434949,5.900000,8.600000,13.945644,4.648548,0.316228,-15.178933
-18.434949,10.800000,3.700000,13.945644,4.648548,0.316228,-15.178933
-18.434949,10.800000,8.600000,13.945644,4.648548,0.316228,-15.178933
0.000000,1.300000,3.600000,0.000000,4.900000,0.500000,-4.400000
18.434949,1.800000,3.600000,1.549516,4.648548,0.316228,-15.178933
18.434949,1.800000,8.500000,1.549516,4.648548,0.316228,-15.178933
18.434949,6.700000,3.600000,1.549516,4.648548,0.316228,-15.178933
18.434949,6.700000,8.500000,1.549516,4.648548,0.316228,-15.178933
18.434949,11.600000,3.600000,1.549516,4.648548,0.316228,-15.178933
18.434949,11.600000,8.500000,1.549516,4.648548,0.316228,-15.178933
63.434949,2.100000,3.700000,8.765386,4.382693,0.223607,-10.733126
63.434949,2.100000,8.600000,8.765386,4.382693,0.223607,-10.733126
75.963757,2.200000,3.900000,19.014793,4.753698,0.412311,-19.790907
75.963757,2.200000,8.800000,19.014793,4.753698,0.412311,-19.790907
75.963757,2.200000,13.700000,19.014793,4.753698,0.412311,-19.790907
75.963757,2.200000,18.600000,19.014793,4.753698,0.412311,-19.790907
63.434949,2.300000,4.300000,8.765386,4.382693,0.223607,-10.733126
63.434949,2.300000,9.200000,8.765386,4.382693,0.223607,-10.733126
90.000000,2.400000,4.500000,0.000000,4.900000,0.200000,-4.700000
-45.000000,2.300000,4.800000,3.464823,3.464823,0.141421,-6.788225
-45.000000,2.300000,9.700000,3.464823,3.464823,0.141421,-6.788225
-18.434949,2.000000,4.900000,13.945644,4.648548,0.316228,-15.178933
-18.434949,2.000000,9.800000,13.945644,4.648548,0.316228,-15.178933
-18.434949,6.900000,4.900000,13.945644,4.648548,0.316228,-15.178933
-18.434949,6.900000,9.800000,13.945644,4.648548,0.316228,-15.178933
-18.434949,11.800000,4.900000,13.945644,4.648548,0.316228,-15.178933
-18.434949,11.800000,9.800000,13.945644,4.648548,0.316228,-15.178933
0.000000,1.800000,4.900000,0.000000,4.900000,0.200000,-4.700000
0.000000,1.500000,4.900000,0.000000,4.900000,0.300000,-4.600000
0.000000,2.600000,4.800000,0.000000,4.900000,0.300000,-4.600000
45.000000,2.500000,4.700000,3.464823,3.464823,0.141421,-6.788225
45.000000,2.500000,9.600000,3.464823,3.464823,0.141421,-6.788225
90.000000,2.500000,4.500000,0.000000,4.900000,0.200000,-4.700000
63.434949,2.300000,4.100000,8.765386,4.382693,0.447214,-10.509519
63.434949,2.300000,9.000000,8.765386,4.382693,0.447214,-10.509519
90.000000,2.300000,3.700000,0.000000,4.900000,0.400000,-4.500000
90.000000,2.300000,3.400000,0.000000,4.900000,0.300000,-4.600000
-63.434949,2.300000,3.400000,2.191347,4.382693,0.223607,-10.733126
-63.434949,2.300000,8.300000,2.191347,4.382693,0.223607,-10.733126
0.000000,2.400000,3.200000,0.000000,4.900000,0.100000,-4.800000
0.000000,2.500000,3.200000,0.000000,4.900000,0.300000,-4.600000
71.565051,2.800000,3.200000,13.945644,4.648548,0.316228,-15.178933
71.565051,2.800000,8.100000,13.945644,4.648548,0.316228,-15.178933
71.565051,2.800000,13.000000,13.945644,4.648548,0.316228,-15.178933
59.036243,2.900000,3.500000,21.008577,12.605146,0.583095,-27.988569
59.036243,2.900000,8.400000,21.008577,12.605146,0.583095,-27.988569
59.036243,2.900000,13.300000,21.008577,12.605146,0.583095,-27.988569
59.036243,2.900000,18.200000,21.008577,12.605146,0.583095,-27.988569
59.036243,2.900000,23.100000,21.008577,12.605146,0.583095,-27.988569
59.036243,7.800000,3.500000,21.008577,12.605146,0.583095,-27.988569
59.036243,7.800000,8.400000,21.008577,12.605146,0.583095,-27.988569
59.036243,7.800000,13.300000,21.008577,12.605146,0.583095,-27.988569
59.036243,7.800000,18.200000,21.008577,12.605146,0.583095,-27.988569
59.036243,7.800000,23.100000,21.008577,12.605146,0.583095,-27.988569
59.036243,12.700000,3.500000,21.008577,12.605146,0.583095,-27.988569
59.036243,12.700000,8.400000,21.008577,12.605146,0.583095,-27.988569
59.036243,12.700000,13.300000,21.008577,12.605146,0.583095,-27.988569
59.036243,12.700000,18.200000,21.008577,12.605146,0.583095,-27.988569
59.036243,12.700000,23.100000,21.008577,12.605146,0.583095,-27.988569
59.036243,17.600000,3.500000,21.008577,12.605146,0.583095,-27.988569
59.036243,17.600000,8.400000,21.008577,12.605146,0.583095,-27.988569
59.036243,17.600000,13.300000,21.008577,12.605146,0.583095,-27.988569
59.036243,17.600000,18.200000,21.008577,12.605146,0.583095,-27.988569
59.036243,17.600000,23.100000,21.008577,12.605146,0.583095,-27.988569
14.036243,3.200000,4.000000,1.188425,4.753698,0.412311,-19.790907
14.036243,3.200000,8.900000,1.188425,4.753698,0.412311,-19.790907
14.036243,8.100000,4.000000,1.188425,4.753698,0.412311,-19.790907
14.036243,8.100000,8.900000,1.188425,4.753698,0.412311,-19.790907
14.036243,13.000000,4.000000,1.188425,4.753698,0.412311,-19.790907
14.036243,13.000000,8.900000,1.188425,4.753698,0.412311,-19.790907
14.036243,17.900000,4.000000,1.188425,4.753698,0.412311,-19.790907
14.036243,17.900000,8.900000,1.188425,4.753698,0.412311,-19.790907
63.434949,3.600000,4.100000,8.765386,4.382693,0.223607,-10.733126
63.434949,3.600000,9.000000,8.765386,4.382693,0.223607,-10.733126
90.000000,3.700000,4.300000,0.000000,4.900000,0.200000,-4.700000
-45.000000,3.500000,4.700000,3.464823,3.464823,0.282843,-6.646804
-45.000000,3.500000,9.600000,3.464823,3.464823,0.282843,-6.646804
-26.565051,3.300000,4.800000,8.765386,4.382693,0.223607,-10.733126
-26.565051,3.300000,9.700000,8.765386,4.382693,0.223607,-10.733126
-26.565051,8.200000,4.800000,8.765386,4.382693,0.223607,-10.733126
-26.565051,8.200000,9.700000,8.765386,4.382693,0.223607,-10.733126
0.000000,2.900000,4.800000,0.000000,4.900000,0.400000,-4.500000
33.690068,3.200000,3.800000,5.436062,8.154093,0.360555,-17.306646
33.690068,3.200000,8.700000,5.436062,8.154093,0.360555,-17.306646
33.690068,3.200000,13.600000,5.436062,8.154093,0.360555,-17.306646
33.690068,8.100000,3.800000,5.436062,8.154093,0.360555,-17.306646
33.690068,8.100000,8.700000,5.436062,8.154093,0.360555,-17.306646
33.690068,8.100000,13.600000,5.436062,8.154093,0.360555,-17.306646
33.690068,13.000000,3.800000,5.436062,8.154093,0.360555,-17.306646
33.690068,13.000000,8.700000,5.436062,8.154093,0.360555,-17.306646
33.690068,13.000000,13.600000,5.436062,8.154093,0.360555,-17.306646
63.434949,3.100000,3.600000,8.765386,4.382693,0.223607,-10.733126
63.434949,3.100000,8.500000,8.765386,4.382693,0.223607,-10.733126
56.309932,2.900000,3.300000,12.231139,8.154093,0.360555,-17.306646
56.309932,2.900000,8.200000,12.231139,8.154093,0.360555,-17.306646
56.309932,2.900000,13.100000,12.231139,8.154093,0.360555,-17.306646
56.309932,2.900000,18.000000,12.231139,8.154093,0.360555,-17.306646
56.309932,7.800000,3.300000,12.231139,8.154093,0.360555,-17.306646
56.309932,7.800000,8.200000,12.231139,8.154093,0.360555,-17.306646
56.309932,7.800000,13.100000,12.231139,8.154093,0.360555,-17.306646
56.309932,7.800000,18.000000,12.231139,8.154093,0.360555,-17.306646
71.565051,2.800000,3.000000,13.945644,4.648548,0.316228,-15.178933
71.565051,2.800000,7.900000,13.945644,4.648548,0.316228,-15.178933
71.565051,2.800000,12.800000,13.945644,4.648548,0.316228,-15.178933
-71.565051,2.800000,3.000000,1.549516,4.648548,0.316228,-15.178933
-71.565051,2.800000,7.900000,1.549516,4.648548,0.316228,-15.178933
-71.565051,2.800000,12.800000,1.549516,4.648548,0.316228,-15.178933
0.000000,2.900000,2.700000,0.000000,4.900000,0.300000,-4.600000
26.565051,3.200000,2.700000,2.191347,4.382693,0.223607,-10.733126
26.565051,3.200000,7.600000,2.191347,4.382693,0.223607,-10.733126
26.565051,8.100000,2.700000,2.191347,4.382693,0.223607,-10.733126
26.565051,8.100000,7.600000,2.191347,4.382693,0.223607,-10.733126
0.000000,3.400000,2.800000,0.000000,4.900000,0.300000,-4.600000
78.690068,3.700000,2.800000,24.024227,4.804845,0.509902,-24.475294
78.690068,3.700000,7.700000,24.024227,4.804845,0.509902,-24.475294
78.690068,3.700000,12.600000,24.024227,4.804845,0.509902,-24.475294
78.690068,3.700000,17.500000,24.024227,4.804845,0.509902,-24.475294
78.690068,3.700000,22.400000,24.024227,4.804845,0.509902,-24.475294
78.690068,3.700000,27.300000,24.024227,4.804845,0.509902,-24.475294
90.000000,3.800000,3.300000,0.000000,4.900000,0.300000,-4.600000
-63.434949,3.700000,3.800000,2.191347,4.382693,0.223607,-10.733126
-63.434949,3.700000,8.700000,2.191347,4.382693,0.223607,-10.733126
-45.000000,3.500000,4.000000,3.464823,3.464823,0.282843,-6.646804
-45.000000,3.500000,8.900000,3.464823,3.464823,0.282843,-6.646804
0.000000,3.500000,4.000000,0.000000,4.900000,0.000000,-4.900000
0.000000,4.000000,4.800000,0.000000,4.900000,0.200000,-4.700000
0.000000,3.900000,4.800000,0.000000,4.900000,0.100000,-4.800000
45.000000,3.800000,4.700000,3.464823,3.464823,0.141421,-6.788225
45.000000,3.800000,9.600000,3.464823,3.464823,0.141421,-6.788225
90.000000,3.800000,4.500000,0.000000,4.900000,0.200000,-4.700000
90.000000,3.800000,4.300000,0.000000,4.900000,0.200000,-4.700000
45.000000,3.700000,4.200000,3.464823,3.464823,0.141421,-6.788225
45.000000,3.700000,9.100000,3.464823,3.464823,0.141421,-6.788225
90.000000,3.700000,4.100000,0.000000,4.900000,0.100000,-4.800000
90.000000,3.700000,3.900000,0.000000,4.900000,0.200000,-4.700000
-45.000000,3.700000,3.900000,3.464823,3.464823,0.141421,-6.788225
-45.000000,3.700000,8.800000,3.464823,3.464823,0.141421,-6.788225
0.000000,3.800000,3.800000,0.000000,4.900000,0.300000,-4.600000
18.434949,4.100000,3.800000,1.549516,4.648548,0.316228,-15.178933
18.434949,4.100000,8.700000,1.549516,4.648548,0.316228,-15.178933
18.434949,9.000000,3.800000,1.549516,4.648548,0.316228,-15.178933
18.434949,9.000000,8.700000,1.549516,4.648548,0.316228,-15.178933
18.434949,13.900000,3.800000,1.549516,4.648548,0.316228,-15.178933
18.434949,13.900000,8.700000,1.549516,4.648548,0.316228,-15.178933
0.000000,4.400000,3.900000,0.000000,4.900000,0.200000,-4.700000
18.434949,4.600000,3.900000,1.549516,4.648548,0.316228,-15.178933
18.434949,4.600000,8.800000,1.549516,4.648548,0.316228,-15.178933
18.434949,9.500000,3.900000,1.549516,4.648548,0.316228,-15.178933
18.434949,9.500000,8.800000,1.549516,4.648548,0.316228,-15.178933
18.434949,14.400000,3.900000,1.549516,4.648548,0.316228,-15.178933
18.434949,14.400000,8.800000,1.549516,4.648548,0.316228,-15.178933
90.000000,4.900000,4.000000,0.000000,4.900000,0.300000,-4.600000
90.000000,4.900000,4.300000,0.000000,4.900000,0.200000,-4.700000
90.000000,4.900000,4.500000,0.000000,4.900000,0.100000,-4.800000
-45.000000,4.700000,4.800000,3.464823,3.464823,0.282843,-6.646804
-45.000000,4.700000,9.700000,3.464823,3.464823,0.282843,-6.646804
0.000000,4.500000,4.800000,0.000000,4.900000,0.200000,-4.700000
0.000000,4.300000,4.800000,0.000000,4.900000,0.200000,-4.700000
0.000000,4.200000,4.800000,0.000000,4.900000,0.100000,-4.800000
45.000000,0.700000,3.400000,3.464823,3.464823,0.282843,-6.646804
45.000000,0.700000,8.300000,3.464823,3.464823,0.282843,-6.646804
90.000000,0.700000,3.100000,0.000000,4.900000,0.300000,-4.600000
-21.801409,0.700000,3.100000,22.747679,9.099072,0.538516,-25.848791
-21.801409,0.700000,8.000000,22.747679,9.099072,0.538516,-25.848791
-21.801409,0.700000,12.900000,22.747679,9.099072,0.538516,-25.848791
-21.801409,5.600000,3.100000,22.747679,9.099072,0.538516,-25.848791
-21.801409,5.600000,8.000000,22.747679,9.099072,0.538516,-25.848791
-21.801409,5.600000,12.900000,22.747679,9.099072,0.538516,-25.848791
-21.801409,10.500000,3.100000,22.747679,9.099072,0.538516,-25.848791
-21.801409,10.500000,8.000000,22.747679,9.099072,0.538516,-25.848791
-21.801409,10.500000,12.900000,22.747679,9.099072,0.538516,-25.848791
-21.801409,15.400000,3.100000,22.747679,9.099072,0.538516,-25.848791
-21.801409,15.400000,8.000000,22.747679,9.099072,0.538516,-25.848791
-21.801409,15.400000,12.900000,22.747679,9.099072,0.538516,-25.848791
-21.801409,20.300000,3.100000,22.747679,9.099072,0.538516,-25.848791
-21.801409,20.300000,8.000000,22.747679,9.099072,0.538516,-25.848791
-21.801409,20.300000,12.900000,22.747679,9.099072,0.538516,-25.848791
0.000000,1.200000,2.900000,0.000000,4.900000,0.300000,-4.600000
33.690068,1.500000,2.900000,5.436062,8.154093,0.360555,-17.306646
33.690068,1.500000,7.800000,5.436062,8.154093,0.360555,-17.306646
33.690068,6.400000,2.900000,5.436062,8.154093,0.360555,-17.306646
33.690068,6.400000,7.800000,5.436062,8.154093,0.360555,-17.306646
33.690068,11.300000,2.900000,5.436062,8.154093,0.360555,-17.306646
33.690068,11.300000,7.800000,5.436062,8.154093,0.360555,-17.306646
18.434949,1.800000,3.100000,1.549516,4.648548,0.316228,-15.178933
18.434949,1.800000,8.000000,1.549516,4.648548,0.316228,-15.178933
18.434949,6.700000,3.100000,1.549516,4.648548,0.316228,-15.178933
18.434949,6.700000,8.000000,1.549516,4.648548,0.316228,-15.178933
18.434949,11.600000,3.100000,1.549516,4.648548,0.316228,-15.178933
18.434949,11.600000,8.000000,1.549516,4.648548,0.316228,-15.178933
63.434949,2.100000,3.200000,8.765386,4.382693,0.223607,-10.733126
63.434949,2.100000,8.100000,8.765386,4.382693,0.223607,-10.733126
90.000000,2.200000,3.400000,0.000000,4.900000,0.100000,-4.800000
0.000000,1.800000,3.500000,0.000000,4.900000,0.400000,-4.500000
0.000000,1.400000,3.500000,0.000000,4.900000,0.400000,-4.500000
0.000000,1.400000,3.500000,0.000000,4.900000,0.000000,-4.900000
-26.565051,1.200000,3.600000,8.765386,4.382693,0.223607,-10.733126
-26.565051,1.200000,8.500000,8.765386,4.382693,0.223607,-10.733126
-26.565051,6.100000,3.600000,8.765386,4.382693,0.223607,-10.733126
-26.565051,6.100000,8.500000,8.765386,4.382693,0.223607,-10.733126
0.000000,0.900000,3.600000,0.000000,4.900000,0.300000,-4.600000
71.565051,0.000000,3.300000,13.945644,4.648548,0.316228,-15.178933
71.565051,0.000000,8.200000,13.945644,4.648548,0.316228,-15.178933
71.565051,0.000000,13.100000,13.945644,4.648548,0.316228,-15.178933
-78.690068,0.000000,3.300000,0.960969,4.804845,0.509902,-24.475294
-78.690068,0.000000,8.200000,0.960969,4.804845,0.509902,-24.475294
-78.690068,0.000000,13.100000,0.960969,4.804845,0.509902,-24.475294
-78.690068,0.000000,18.000000,0.960969,4.804845,0.509902,-24.475294
-78.690068,0.000000,22.900000,0.960969,4.804845,0.509902,-24.475294
-78.690068,0.000000,27.800000,0.960969,4.804845,0.509902,-24.475294
-59.036243,0.100000,2.800000,7.563088,12.605146,0.583095,-27.988569
-59.036243,0.100000,7.700000,7.563088,12.605146,0.583095,-27.988569
-59.036243,0.100000,12.600000,7.563088,12.605146,0.583095,-27.988569
-59.036243,0.100000,17.500000,7.563088,12.605146,0.583095,-27.988569
-59.036243,0.100000,22.400000,7.563088,12.605146,0.583095,-27.988569
-59.036243,5.000000,2.800000,7.563088,12.605146,0.583095,-27.988569
-59.036243,5.000000,7.700000,7.563088,12.605146,0.583095,-27.988569
-59.036243,5.000000,12.600000,7.563088,12.605146,0.583095,-27.988569
-59.036243,5.000000,17.500000,7.563088,12.605146,0.583095,-27.988569
-59.036243,5.000000,22.400000,7.563088,12.605146,0.583095,-27.988569
-59.036243,9.900000,2.800000,7.563088,12.605146,0.583095,-27.988569
-59.036243,9.900000,7.700000,7.563088,12.605146,0.583095,-27.988569
-59.036243,9.900000,12.600000,7.563088,12.605146,0.583095,-27.988569
-59.036243,9.900000,17.500000,7.563088,12.605146,0.583095,-27.988569
-59.036243,9.900000,22.400000,7.563088,12.605146,0.583095,-27.988569
-59.036243,14.800000,2.800000,7.563088,12.605146,0.583095,-27.988569
-59.036243,14.800000,7.700000,7.563088,12.605146,0.583095,-27.988569
-59.036243,14.800000,12.600000,7.563088,12.605146,0.583095,-27.988569
-59.036243,14.800000,17.500000,7.563088,12.605146,0.583095,-27.988569
-59.036243,14.800000,22.400000,7.563088,12.605146,0.583095,-27.988569
56.309932,0.400000,2.300000,12.231139,8.154093,0.360555,-17.306646
56.309932,0.400000,7.200000,12.231139,8.154093,0.360555,-17.306646
56.309932,0.400000,12.100000,12.231139,8.154093,0.360555,-17.306646
56.309932,0.400000,17.000000,12.231139,8.154093,0.360555,-17.306646
56.309932,5.300000,2.300000,12.231139,8.154093,0.360555,-17.306646
56.309932,5.300000,7.200000,12.231139,8.154093,0.360555,-17.306646
56.309932,5.300000,12.100000,12.231139,8.154093,0.360555,-17.306646
56.309932,5.300000,17.000000,12.231139,8.154093,0.360555,-17.306646
90.000000,0.600000,2.600000,0.000000,4.900000,0.300000,-4.600000
90.000000,0.600000,2.900000,0.000000,4.900000,0.300000,-4.600000
90.000000,0.600000,3.200000,0.000000,4.900000,0.200000,-4.700000
45.000000,0.600000,3.400000,3.464823,3.464823,0.141421,-6.788225
45.000000,0.600000,8.300000,3.464823,3.464823,0.141421,-6.788225
63.434949,0.700000,3.500000,8.765386,4.382693,0.223607,-10.733126
63.434949,0.700000,8.400000,8.765386,4.382693,0.223607,-10.733126
0.000000,0.600000,3.700000,0.000000,4.900000,0.200000,-4.700000
0.000000,0.200000,3.700000,0.000000,4.900000,0.400000,-4.500000
45.000000,0.100000,3.600000,3.464823,3.464823,0.141421,-6.788225
45.000000,0.100000,8.500000,3.464823,3.464823,0.141421,-6.788225
26.565051,1.900000,3.000000,2.191347,4.382693,0.223607,-10.733126
26.565051,1.900000,7.900000,2.191347,4.382693,0.223607,-10.733126
26.565051,6.800000,3.000000,2.191347,4.382693,0.223607,-10.733126
26.565051,6.800000,7.900000,2.191347,4.382693,0.223607,-10.733126
71.565051,1.800000,2.700000,13.945644,4.648548,0.316228,-15.178933
71.565051,1.800000,7.600000,13.945644,4.648548,0.316228,-15.178933
71.565051,1.800000,12.500000,13.945644,4.648548,0.316228,-15.178933
-63.434949,1.800000,2.700000,2.191347,4.382693,0.223607,-10.733126
-63.434949,1.800000,7.600000,2.191347,4.382693,0.223607,-10.733126
-18.434949,1.900000,2.500000,13.945644,4.648548,0.316228,-15.178933
-18.434949,1.900000,7.400000,13.945644,4.648548,0.316228,-15.178933
-18.434949,6.800000,2.500000,13.945644,4.648548,0.316228,-15.178933
-18.434949,6.800000,7.400000,13.945644,4.648548,0.316228,-15.178933
-18.434949,11.700000,2.500000,13.945644,4.648548,0.316228,-15.178933
-18.434949,11.700000,7.400000,13.945644,4.648548,0.316228,-15.178933
0.000000,2.200000,2.400000,0.000000,4.900000,0.500000,-4.400000
90.000000,2.700000,2.400000,0.000000,4.900000,0.200000,-4.700000
90.000000,2.700000,2.600000,0.000000,4.900000,0.200000,-4.700000
90.000000,2.700000,2.800000,0.000000,4.900000,0.200000,-4.700000
-45.000000,2.600000,3.100000,3.464823,3.464823,0.141421,-6.788225
-45.000000,2.600000,8.000000,3.464823,3.464823,0.141421,-6.788225
0.000000,2.100000,3.100000,0.000000,4.900000,0.500000,-4.400000
90.000000,0.700000,2.500000,0.000000,4.900000,0.400000,-4.500000
56.309932,0.500000,2.200000,12.231139,8.154093,0.360555,-17.306646
56.309932,0.500000,7.100000,12.231139,8.154093,0.360555,-17.306646
56.309932,0.500000,12.000000,12.231139,8.154093,0.360555,-17.306646
56.309932,0.500000,16.900000,12.231139,8.154093,0.360555,-17.306646
56.309932,5.400000,2.200000,12.231139,8.154093,0.360555,-17.306646
56.309932,5.400000,7.100000,12.231139,8.154093,0.360555,-17.306646
56.309932,5.400000,12.000000,12.231139,8.154093,0.360555,-17.306646
56.309932,5.400000,16.900000,12.231139,8.154093,0.360555,-17.306646
71.565051,0.400000,1.900000,13.945644,4.648548,0.316228,-15.178933
71.565051,0.400000,6.800000,13.945644,4.648548,0.316228,-15.178933
71.565051,0.400000,11.700000,13.945644,4.648548,0.316228,-15.178933
-63.434949,0.400000,1.900000,2.191347,4.382693,0.447214,-10.509519
-63.434949,0.400000,6.800000,2.191347,4.382693,0.447214,-10.509519
-11.309932,0.600000,1.500000,24.024227,4.804845,0.509902,-24.475294
-11.309932,0.600000,6.400000,24.024227,4.804845,0.509902,-24.475294
-11.309932,5.500000,1.500000,24.024227,4.804845,0.509902,-24.475294
-11.309932,5.500000,6.400000,24.024227,4.804845,0.509902,-24.475294
-11.309932,10.400000,1.500000,24.024227,4.804845,0.509902,-24.475294
-11.309932,10.400000,6.400000,24.024227,4.804845,0.509902,-24.475294
-11.309932,15.300000,1.500000,24.024227,4.804845,0.509902,-24.475294
-11.309932,15.300000,6.400000,24.024227,4.804845,0.509902,-24.475294
-11.309932,20.200000,1.500000,24.024227,4.804845,0.509902,-24.475294
-11.309932,20.200000,6.400000,24.024227,4.804845,0.509902,-24.475294
0.000000,1.100000,1.400000,0.000000,4.900000,0.600000,-4.300000
90.000000,1.700000,1.400000,0.000000,4.900000,0.400000,-4.500000
-75.963757,1.600000,2.200000,1.188425,4.753698,0.412311,-19.790907
-75.963757,1.600000,7.100000,1.188425,4.753698,0.412311,-19.790907
-75.963757,1.600000,12.000000,1.188425,4.753698,0.412311,-19.790907
-75.963757,1.600000,16.900000,1.188425,4.753698,0.412311,-19.790907
90.000000,1.600000,2.200000,0.000000,4.900000,0.200000,-4.700000
45.000000,1.600000,2.400000,3.464823,3.464823,0.141421,-6.788225
45.000000,1.600000,7.300000,3.464823,3.464823,0.141421,-6.788225
90.000000,1.700000,2.500000,0.000000,4.900000,0.200000,-4.700000
-26.565051,1.500000,2.800000,8.765386,4.382693,0.223607,-10.733126
-26.565051,1.500000,7.700000,8.765386,4.382693,0.223607,-10.733126
-26.565051,6.400000,2.800000,8.765386,4.382693,0.223607,-10.733126
-26.565051,6.400000,7.700000,8.765386,4.382693,0.223607,-10.733126
-7.125016,0.700000,2.900000,38.897293,4.862162,0.806226,-38.698837
-7.125016,0.700000,7.800000,38.897293,4.862162,0.806226,-38.698837
-7.125016,5.600000,2.900000,38.897293,4.862162,0.806226,-38.698837
-7.125016,5.600000,7.800000,38.897293,4.862162,0.806226,-38.698837
-7.125016,10.500000,2.900000,38.897293,4.862162,0.806226,-38.698837
-7.125016,10.500000,7.800000,38.897293,4.862162,0.806226,-38.698837
-7.125016,15.400000,2.900000,38.897293,4.862162,0.806226,-38.698837
-7.125016,15.400000,7.800000,38.897293,4.862162,0.806226,-38.698837
-7.125016,20.300000,2.900000,38.897293,4.862162,0.806226,-38.698837
-7.125016,20.300000,7.800000,38.897293,4.862162,0.806226,-38.698837
-7.125016,25.200000,2.900000,38.897293,4.862162,0.806226,-38.698837
-7.125016,25.200000,7.800000,38.897293,4.862162,0.806226,-38.698837
-7.125016,30.100000,2.900000,38.897293,4.862162,0.806226,-38.698837
-7.125016,30.100000,7.800000,38.897293,4.862162,0.806226,-38.698837
-7.125016,35.000000,2.900000,38.897293,4.862162,0.806226,-38.698837
-7.125016,35.000000,7.800000,38.897293,4.862162,0.806226,-38.698837
71.565051,1.700000,2.100000,13.945644,4.648548,0.316228,-15.178933
71.565051,1.700000,7.000000,13.945644,4.648548,0.316228,-15.178933
71.565051,1.700000,11.900000,13.945644,4.648548,0.316228,-15.178933
-82.874984,1.700000,2.100000,0.607770,4.862162,0.806226,-38.698837
-82.874984,1.700000,7.000000,0.607770,4.862162,0.806226,-38.698837
-82.874984,1.700000,11.900000,0.607770,4.862162,0.806226,-38.698837
-82.874984,1.700000,16.800000,0.607770,4.862162,0.806226,-38.698837
-82.874984,1.700000,21.700000,0.607770,4.862162,0.806226,-38.698837
-82.874984,1.700000,26.600000,0.607770,4.862162,0.806226,-38.698837
-82.874984,1.700000,31.500000,0.607770,4.862162,0.806226,-38.698837
-82.874984,1.700000,36.400000,0.607770,4.862162,0.806226,-38.698837
-82.874984,1.700000,41.300000,0.607770,4.862162,0.806226,-38.698837
-21.801409,1.800000,1.300000,22.747679,9.099072,0.538516,-25.848791
-21.801409,1.800000,6.200000,22.747679,9.099072,0.538516,-25.848791
-21.801409,1.800000,11.100000,22.747679,9.099072,0.538516,-25.848791
-21.801409,6.700000,1.300000,22.747679,9.099072,0.538516,-25.848791
-21.801409,6.700000,6.200000,22.747679,9.099072,0.538516,-25.848791
-21.801409,6.700000,11.100000,22.747679,9.099072,0.538516,-25.848791
-21.801409,11.600000,1.300000,22.747679,9.099072,0.538516,-25.848791
-21.801409,11.600000,6.200000,22.747679,9.099072,0.538516,-25.848791
-21.801409,11.600000,11.100000,22.747679,9.099072,0.538516,-25.848791
-21.801409,16.500000,1.300000,22.747679,9.099072,0.538516,-25.848791
-21.801409,16.500000,6.200000,22.747679,9.099072,0.538516,-25.848791
-21.801409,16.500000,11.100000,22.747679,9.099072,0.538516,-25.848791
-21.801409,21.400000,1.300000,22.747679,9.099072,0.538516,-25.848791
-21.801409,21.400000,6.200000,22.747679,9.099072,0.538516,-25.848791
-21.801409,21.400000,11.100000,22.747679,9.099072,0.538516,-25.848791
26.565051,2.300000,1.100000,2.191347,4.382693,0.447214,-10.509519
26.565051,2.300000,6.000000,2.191347,4.382693,0.447214,-10.509519
26.565051,7.200000,1.100000,2.191347,4.382693,0.447214,-10.509519
26.565051,7.200000,6.000000,2.191347,4.382693,0.447214,-10.509519
71.565051,2.700000,1.300000,13.945644,4.648548,0.316228,-15.178933
71.565051,2.700000,6.200000,13.945644,4.648548,0.316228,-15.178933
71.565051,2.700000,11.100000,13.945644,4.648548,0.316228,-15.178933
90.000000,2.800000,1.600000,0.000000,4.900000,0.300000,-4.600000
-63.434949,2.700000,2.100000,2.191347,4.382693,0.223607,-10.733126
-63.434949,2.700000,7.000000,2.191347,4.382693,0.223607,-10.733126
-26.565051,2.500000,2.200000,8.765386,4.382693,0.223607,-10.733126
-26.565051,2.500000,7.100000,8.765386,4.382693,0.223607,-10.733126
-26.565051,7.400000,2.200000,8.765386,4.382693,0.223607,-10.733126
-26.565051,7.400000,7.100000,8.765386,4.382693,0.223607,-10.733126
-18.434949,2.200000,2.300000,13.945644,4.648548,0.316228,-15.178933
-18.434949,2.200000,7.200000,13.945644,4.648548,0.316228,-15.178933
-18.434949,7.100000,2.300000,13.945644,4.648548,0.316228,-15.178933
-18.434949,7.100000,7.200000,13.945644,4.648548,0.316228,-15.178933
-18.434949,12.000000,2.300000,13.945644,4.648548,0.316228,-15.178933
-18.434949,12.000000,7.200000,13.945644,4.648548,0.316228,-15.178933
-26.565051,2.000000,2.400000,8.765386,4.382693,0.223607,-10.733126
-26.565051,2.000000,7.300000,8.765386,4.382693,0.223607,-10.733126
-26.565051,6.900000,2.400000,8.765386,4.382693,0.223607,-10.733126
-26.565051,6.900000,7.300000,8.765386,4.382693,0.223607,-10.733126
0.000000,1.800000,2.400000,0.000000,4.900000,0.200000,-4.700000
45.000000,2.900000,2.500000,3.464823,3.464823,0.141421,-6.788225
45.000000,2.900000,7.400000,3.464823,3.464823,0.141421,-6.788225
71.565051,2.800000,2.200000,13.945644,4.648548,0.316228,-15.178933
71.565051,2.800000,7.100000,13.945644,4.648548,0.316228,-15.178933
71.565051,2.800000,12.000000,13.945644,4.648548,0.316228,-15.178933
-71.565051,2.800000,2.200000,1.549516,4.648548,0.316228,-15.178933
-71.565051,2.800000,7.100000,1.549516,4.648548,0.316228,-15.178933
-71.565051,2.800000,12.000000,1.549516,4.648548,0.316228,-15.178933
-75.963757,2.900000,1.900000,1.188425,4.753698,0.412311,-19.790907
-75.963757,2.900000,6.800000,1.188425,4.753698,0.412311,-19.790907
-75.963757,2.900000,11.700000,1.188425,4.753698,0.412311,-19.790907
-75.963757,2.900000,16.600000,1.188425,4.753698,0.412311,-19.790907
-45.000000,3.000000,1.500000,3.464823,3.464823,0.424264,-6.505382
-45.000000,3.000000,6.400000,3.464823,3.464823,0.424264,-6.505382
0.000000,3.300000,1.200000,0.000000,4.900000,0.400000,-4.500000
90.000000,3.700000,1.200000,0.000000,4.900000,0.600000,-4.300000
45.000000,3.700000,1.800000,3.464823,3.464823,0.141421,-6.788225
45.000000,3.700000,6.700000,3.464823,3.464823,0.141421,-6.788225
45.000000,3.800000,1.900000,3.464823,3.464823,0.282843,-6.646804
45.000000,3.800000,6.800000,3.464823,3.464823,0.282843,-6.646804
71.565051,4.000000,2.100000,13.945644,4.648548,0.316228,-15.178933
71.565051,4.000000,7.000000,13.945644,4.648548,0.316228,-15.178933
71.565051,4.000000,11.900000,13.945644,4.648548,0.316228,-15.178933
90.000000,4.100000,2.400000,0.000000,4.900000,0.200000,-4.700000
90.000000,4.100000,2.600000,0.000000,4.900000,0.100000,-4.800000
0.000000,3.800000,2.700000,0.000000,4.900000,0.300000,-4.600000
0.000000,3.500000,2.700000,0.000000,4.900000,0.300000,-4.600000
11.309932,3.000000,2.600000,0.960969,4.804845,0.509902,-24.475294
11.309932,3.000000,7.500000,0.960969,4.804845,0.509902,-24.475294
11.309932,7.900000,2.600000,0.960969,4.804845,0.509902,-24.475294
11.309932,7.900000,7.500000,0.960969,4.804845,0.509902,-24.475294
11.309932,12.800000,2.600000,0.960969,4.804845,0.509902,-24.475294
11.309932,12.800000,7.500000,0.960969,4.804845,0.509902,-24.475294
11.309932,17.700000,2.600000,0.960969,4.804845,0.509902,-24.475294
11.309932,17.700000,7.500000,0.960969,4.804845,0.509902,-24.475294
11.309932,22.600000,2.600000,0.960969,4.804845,0.509902,-24.475294
11.309932,22.600000,7.500000,0.960969,4.804845,0.509902,-24.475294
18.434949,4.000000,3.700000,1.549516,4.648548,0.316228,-15.178933
18.434949,4.000000,8.600000,1.549516,4.648548,0.316228,-15.178933
18.434949,8.900000,3.700000,1.549516,4.648548,0.316228,-15.178933
18.434949,8.900000,8.600000,1.549516,4.648548,0.316228,-15.178933
18.434949,13.800000,3.700000,1.549516,4.648548,0.316228,-15.178933
18.434949,13.800000,8.600000,1.549516,4.648548,0.316228,-15.178933
90.000000,4.000000,3.600000,0.000000,4.900000,0.100000,-4.800000
63.434949,3.900000,3.400000,8.765386,4.382693,0.223607,-10.733126
63.434949,3.900000,8.300000,8.765386,4.382693,0.223607,-10.733126
71.565051,3.800000,3.100000,13.945644,4.648548,0.316228,-15.178933
71.565051,3.800000,8.000000,13.945644,4.648548,0.316228,-15.178933
71.565051,3.800000,12.900000,13.945644,4.648548,0.316228,-15.178933
90.000000,3.800000,2.900000,0.000000,4.900000,0.200000,-4.700000
-21.801409,3.800000,2.900000,22.747679,9.099072,0.538516,-25.848791
-21.801409,3.800000,7.800000,22.747679,9.099072,0.538516,-25.848791
-21.801409,3.800000,12.700000,22.747679,9.099072,0.538516,-25.848791
-21.801409,8.700000,2.900000,22.747679,9.099072,0.538516,-25.848791
-21.801409,8.700000,7.800000,22.747679,9.099072,0.538516,-25.848791
-21.801409,8.700000,12.700000,22.747679,9.099072,0.538516,-25.848791
-21.801409,13.600000,2.900000,22.747679,9.099072,0.538516,-25.848791
-21.801409,13.600000,7.800000,22.747679,9.099072,0.538516,-25.848791
-21.801409,13.600000,12.700000,22.747679,9.099072,0.538516,-25.848791
-21.801409,18.500000,2.900000,22.747679,9.099072,0.538516,-25.848791
-21.801409,18.500000,7.800000,22.747679,9.099072,0.538516,-25.848791
-21.801409,18.500000,12.700000,22.747679,9.099072,0.538516,-25.848791
-21.801409,23.400000,2.900000,22.747679,9.099072,0.538516,-25.848791
-21.801409,23.400000,7.800000,22.747679,9.099072,0.538516,-25.848791
-21.801409,23.400000,12.700000,22.747679,9.099072,0.538516,-25.848791
-18.434949,4.300000,2.700000,13.945644,4.648548,0.316228,-15.178933
-18.434949,4.300000,7.600000,13.945644,4.648548,0.316228,-15.178933
-18.434949,9.200000,2.700000,13.945644,4.648548,0.316228,-15.178933
-18.434949,9.200000,7.600000,13.945644,4.648548,0.316228,-15.178933
-18.434949,14.100000,2.700000,13.945644,4.648548,0.316228,-15.178933
-18.434949,14.100000,7.600000,13.945644,4.648548,0.316228,-15.178933
90.000000,4.600000,2.600000,0.000000,4.900000,0.200000,-4.700000
71.565051,4.600000,2.800000,13.945644,4.648548,0.316228,-15.178933
71.565051,4.600000,7.700000,13.945644,4.648548,0.316228,-15.178933
71.565051,4.600000,12.600000,13.945644,4.648548,0.316228,-15.178933
63.434949,4.700000,3.100000,8.765386,4.382693,0.223607,-10.733126
63.434949,4.700000,8.000000,8.765386,4.382693,0.223607,-10.733126
-45.000000,4.700000,3.400000,3.464823,3.464823,0.141421,-6.788225
-45.000000,4.700000,8.300000,3.464823,3.464823,0.141421,-6.788225
-45.000000,4.600000,3.500000,3.464823,3.464823,0.141421,-6.788225
-45.000000,4.600000,8.400000,3.464823,3.464823,0.141421,-6.788225
-63.434949,4.500000,3.700000,2.191347,4.382693,0.223607,-10.733126
-63.434949,4.500000,8.600000,2.191347,4.382693,0.223607,-10.733126
-26.565051,4.300000,3.800000,8.765386,4.382693,0.223607,-10.733126
-26.565051,4.300000,8.700000,8.765386,4.382693,0.223607,-10.733126
-26.565051,9.200000,3.800000,8.765386,4.382693,0.223607,-10.733126
-26.565051,9.200000,8.700000,8.765386,4.382693,0.223607,-10.733126
63.434949,0.000000,2.300000,8.765386,4.382693,0.223607,-10.733126
63.434949,0.000000,7.200000,8.765386,4.382693,0.223607,-10.733126
90.000000,0.000000,2.100000,0.000000,4.900000,0.200000,-4.700000
90.000000,0.000000,1.700000,0.000000,4.900000,0.400000,-4.500000
90.000000,0.000000,1.000000,0.000000,4.900000,0.700000,-4.200000
-63.434949,0.000000,1.000000,2.191347,4.382693,0.447214,-10.509519
-63.434949,0.000000,5.900000,2.191347,4.382693,0.447214,-10.509519
26.565051,0.200000,0.600000,2.191347,4.382693,0.223607,-10.733126
26.565051,0.200000,5.500000,2.191347,4.382693,0.223607,-10.733126
26.565051,5.100000,0.600000,2.191347,4.382693,0.223607,-10.733126
26.565051,5.100000,5.500000,2.191347,4.382693,0.223607,-10.733126
90.000000,0.400000,0.700000,0.000000,4.900000,0.200000,-4.700000
90.000000,0.400000,0.900000,0.000000,4.900000,0.100000,-4.800000
63.434949,0.400000,1.000000,8.765386,4.382693,0.223607,-10.733126
63.434949,0.400000,5.900000,8.765386,4.382693,0.223607,-10.733126
90.000000,0.500000,1.200000,0.000000,4.900000,0.200000,-4.700000
90.000000,0.500000,1.400000,0.000000,4.900000,0.200000,-4.700000
-56.309932,0.300000,1.900000,5.436062,8.154093,0.360555,-17.306646
-56.309932,0.300000,6.800000,5.436062,8.154093,0.360555,-17.306646
-56.309932,0.300000,11.700000,5.436062,8.154093,0.360555,-17.306646
-56.309932,0.300000,16.600000,5.436062,8.154093,0.360555,-17.306646
-56.309932,5.200000,1.900000,5.436062,8.154093,0.360555,-17.306646
-56.309932,5.200000,6.800000,5.436062,8.154093,0.360555,-17.306646
-56.309932,5.200000,11.700000,5.436062,8.154093,0.360555,-17.306646
-56.309932,5.200000,16.600000,5.436062,8.154093,0.360555,-17.306646
63.434949,0.300000,1.900000,8.765386,4.382693,0.223607,-10.733126
63.434949,0.300000,6.800000,8.765386,4.382693,0.223607,-10.733126
-63.434949,0.300000,2.300000,2.191347,4.382693,0.223607,-10.733126
-63.434949,0.300000,7.200000,2.191347,4.382693,0.223607,-10.733126
-45.000000,0.100000,2.500000,3.464823,3.464823,0.282843,-6.646804
-45.000000,0.100000,7.400000,3.464823,3.464823,0.282843,-6.646804
0.000000,1.300000,1.300000,0.000000,4.900000,0.100000,-4.800000
63.434949,1.200000,1.100000,8.765386,4.382693,0.223607,-10.733126
63.434949,1.200000,6.000000,8.765386,4.382693,0.223607,-10.733126
-45.000000,1.200000,1.100000,3.464823,3.464823,0.141421,-6.788225
-45.000000,1.200000,6.000000,3.464823,3.464823,0.141421,-6.788225
-33.690068,1.300000,1.000000,12.231139,8.154093,0.360555,-17.306646
-33.690068,1.300000,5.900000,12.231139,8.154093,0.360555,-17.306646
-33.690068,6.200000,1.000000,12.231139,8.154093,0.360555,-17.306646
-33.690068,6.200000,5.900000,12.231139,8.154093,0.360555,-17.306646
-33.690068,11.100000,1.000000,12.231139,8.154093,0.360555,-17.306646
-33.690068,11.100000,5.900000,12.231139,8.154093,0.360555,-17.306646
26.565051,1.600000,0.800000,2.191347,4.382693,0.223607,-10.733126
26.565051,1.600000,5.700000,2.191347,4.382693,0.223607,-10.733126
26.565051,6.500000,0.800000,2.191347,4.382693,0.223607,-10.733126
26.565051,6.500000,5.700000,2.191347,4.382693,0.223607,-10.733126
45.000000,1.800000,0.900000,3.464823,3.464823,0.141421,-6.788225
45.000000,1.800000,5.800000,3.464823,3.464823,0.141421,-6.788225
90.000000,1.900000,1.000000,0.000000,4.900000,0.200000,-4.700000
-26.565051,1.700000,1.300000,8.765386,4.382693,0.223607,-10.733126
-26.565051,1.700000,6.200000,8.765386,4.382693,0.223607,-10.733126
-26.565051,6.600000,1.300000,8.765386,4.382693,0.223607,-10.733126
-26.565051,6.600000,6.200000,8.765386,4.382693,0.223607,-10.733126
0.000000,1.500000,1.300000,0.000000,4.900000,0.200000,-4.700000
0.000000,1.500000,1.300000,0.000000,4.900000,0.000000,-4.900000
0.000000,1.500000,1.300000,0.000000,4.900000,0.000000,-4.900000
0.000000,1.400000,1.300000,0.000000,4.900000,0.100000,-4.800000
63.434949,1.900000,0.900000,8.765386,4.382693,0.223607,-10.733126
63.434949,1.900000,5.800000,8.765386,4.382693,0.223607,-10.733126
45.000000,1.700000,0.700000,3.464823,3.464823,0.282843,-6.646804
45.000000,1.700000,5.600000,3.464823,3.464823,0.282843,-6.646804
63.434949,1.600000,0.500000,8.765386,4.382693,0.223607,-10.733126
63.434949,1.600000,5.400000,8.765386,4.382693,0.223607,-10.733126
-71.565051,1.600000,0.500000,1.549516,4.648548,0.316228,-15.178933
-71.565051,1.600000,5.400000,1.549516,4.648548,0.316228,-15.178933
-71.565051,1.600000,10.300000,1.549516,4.648548,0.316228,-15.178933
0.000000,1.700000,0.200000,0.000000,4.900000,0.100000,-4.800000
-11.309932,1.800000,0.200000,24.024227,4.804845,0.509902,-24.475294
-11.309932,1.800000,5.100000,24.024227,4.804845,0.509902,-24.475294
-11.309932,6.700000,0.200000,24.024227,4.804845,0.509902,-24.475294
-11.309932,6.700000,5.100000,24.024227,4.804845,0.509902,-24.475294
-11.309932,11.600000,0.200000,24.024227,4.804845,0.509902,-24.475294
-11.309932,11.600000,5.100000,24.024227,4.804845,0.509902,-24.475294
-11.309932,16.500000,0.200000,24.024227,4.804845,0.509902,-24.475294
-11.309932,16.500000,5.100000,24.024227,4.804845,0.509902,-24.475294
-11.309932,21.400000,0.200000,24.024227,4.804845,0.509902,-24.475294
-11.309932,21.400000,5.100000,24.024227,4.804845,0.509902,-24.475294
-26.565051,2.300000,0.100000,8.765386,4.382693,0.223607,-10.733126
-26.565051,2.300000,5.000000,8.765386,4.382693,0.223607,-10.733126
-26.565051,7.200000,0.100000,8.765386,4.382693,0.223607,-10.733126
-26.565051,7.200000,5.000000,8.765386,4.382693,0.223607,-10.733126
18.434949,2.500000,0.000000,1.549516,4.648548,0.316228,-15.178933
18.434949,2.500000,4.900000,1.549516,4.648548,0.316228,-15.178933
18.434949,7.400000,0.000000,1.549516,4.648548,0.316228,-15.178933
18.434949,7.400000,4.900000,1.549516,4.648548,0.316228,-15.178933
18.434949,12.300000,0.000000,1.549516,4.648548,0.316228,-15.178933
18.434949,12.300000,4.900000,1.549516,4.648548,0.316228,-15.178933
45.000000,2.800000,0.100000,3.464823,3.464823,0.141421,-6.788225
45.000000,2.800000,5.000000,3.464823,3.464823,0.141421,-6.788225
90.000000,2.900000,0.200000,0.000000,4.900000,0.200000,-4.700000
71.565051,2.900000,0.400000,13.945644,4.648548,0.316228,-15.178933
71.565051,2.900000,5.300000,13.945644,4.648548,0.316228,-15.178933
71.565051,2.900000,10.200000,13.945644,4.648548,0.316228,-15.178933
-45.000000,2.700000,1.000000,3.464823,3.464823,0.424264,-6.505382
-45.000000,2.700000,5.900000,3.464823,3.464823,0.424264,-6.505382
0.000000,2.600000,1.000000,0.000000,4.900000,0.100000,-4.800000
0.000000,2.400000,1.000000,0.000000,4.900000,0.200000,-4.700000
0.000000,2.200000,1.000000,0.000000,4.900000,0.200000,-4.700000
-26.565051,2.000000,1.100000,8.765386,4.382693,0.223607,-10.733126
-26.565051,2.000000,6.000000,8.765386,4.382693,0.223607,-10.733126
-26.565051,6.900000,1.100000,8.765386,4.382693,0.223607,-10.733126
-26.565051,6.900000,6.000000,8.765386,4.382693,0.223607,-10.733126
90.000000,2.900000,1.100000,0.000000,4.900000,0.200000,-4.700000
-63.434949,2.900000,1.100000,2.191347,4.382693,0.223607,-10.733126
-63.434949,2.900000,6.000000,2.191347,4.382693,0.223607,-10.733126
-45.000000,3.000000,0.900000,3.464823,3.464823,0.565685,-6.363961
-45.000000,3.000000,5.800000,3.464823,3.464823,0.565685,-6.363961
33.690068,3.400000,0.500000,5.436062,8.154093,0.360555,-17.306646
33.690068,3.400000,5.400000,5.436062,8.154093,0.360555,-17.306646
33.690068,8.300000,0.500000,5.436062,8.154093,0.360555,-17.306646
33.690068,8.300000,5.400000,5.436062,8.154093,0.360555,-17.306646
33.690068,13.200000,0.500000,5.436062,8.154093,0.360555,-17.306646
33.690068,13.200000,5.400000,5.436062,8.154093,0.360555,-17.306646
90.000000,3.700000,0.700000,0.000000,4.900000,0.200000,-4.700000
-26.565051,3.300000,1.100000,8.765386,4.382693,0.447214,-10.509519
-26.565051,3.300000,6.000000,8.765386,4.382693,0.447214,-10.509519
-26.565051,8.200000,1.100000,8.765386,4.382693,0.447214,-10.509519
-26.565051,8.200000,6.000000,8.765386,4.382693,0.447214,-10.509519
-45.000000,3.100000,1.300000,3.464823,3.464823,0.282843,-6.646804
-45.000000,3.100000,6.200000,3.464823,3.464823,0.282843,-6.646804
0.000000,2.900000,1.300000,0.000000,4.900000,0.200000,-4.700000
26.565051,3.100000,0.300000,2.191347,4.382693,0.223607,-10.733126
26.565051,3.100000,5.200000,2.191347,4.382693,0.223607,-10.733126
26.565051,8.000000,0.300000,2.191347,4.382693,0.223607,-10.733126
26.565051,8.000000,5.200000,2.191347,4.382693,0.223607,-10.733126
63.434949,3.000000,0.100000,8.765386,4.382693,0.223607,-10.733126
63.434949,3.000000,5.000000,8.765386,4.382693,0.223607,-10.733126
-45.000000,3.000000,0.100000,3.464823,3.464823,0.141421,-6.788225
-45.000000,3.000000,5.000000,3.464823,3.464823,0.141421,-6.788225
0.000000,3.100000,0.000000,0.000000,4.900000,0.400000,-4.500000
45.000000,3.500000,0.000000,3.464823,3.464823,0.141421,-6.788225
45.000000,3.500000,4.900000,3.464823,3.464823,0.141421,-6.788225
90.000000,3.600000,0.100000,0.000000,4.900000,0.300000,-4.600000
0.000000,3.300000,0.400000,0.000000,4.900000,0.300000,-4.600000
45.000000,1.200000,0.600000,3.464823,3.464823,0.141421,-6.788225
45.000000,1.200000,5.500000,3.464823,3.464823,0.141421,-6.788225
63.434949,1.100000,0.400000,8.765386,4.382693,0.223607,-10.733126
63.434949,1.100000,5.300000,8.765386,4.382693,0.223607,-10.733126
-45.000000,1.100000,0.400000,3.464823,3.464823,0.282843,-6.646804
-45.000000,1.100000,5.300000,3.464823,3.464823,0.282843,-6.646804
-26.565051,1.300000,0.200000,8.765386,4.382693,0.223607,-10.733126
-26.565051,1.300000,5.100000,8.765386,4.382693,0.223607,-10.733126
-26.565051,6.200000,0.200000,8.765386,4.382693,0.223607,-10.733126
-26.565051,6.200000,5.100000,8.765386,4.382693,0.223607,-10.733126
90.000000,1.500000,0.100000,0.000000,4.900000,0.600000,-4.300000
0.000000,1.300000,0.700000,0.000000,4.900000,0.200000,-4.700000
0.000000,0.600000,1.400000,0.000000,4.900000,0.100000,-4.800000
90.000000,0.600000,1.300000,0.000000,4.900000,0.100000,-4.800000
63.434949,0.500000,1.100000,8.765386,4.382693,0.223607,-10.733126
63.434949,0.500000,6.000000,8.765386,4.382693,0.223607,-10.733126
90.000000,0.500000,1.000000,0.000000,4.900000,0.100000,-4.800000
90.000000,0.500000,0.700000,0.000000,4.900000,0.300000,-4.600000
-63.434949,0.500000,0.700000,2.191347,4.382693,0.223607,-10.733126
-63.434949,0.500000,5.600000,2.191347,4.382693,0.223607,-10.733126
-14.036243,0.600000,0.500000,19.014793,4.753698,0.412311,-19.790907
-14.036243,5.500000,0.500000,19.014793,4.753698,0.412311,-19.790907
-14.036243,10.400000,0.500000,19.014793,4.753698,0.412311,-19.790907
-14.036243,15.300000,0.500000,19.014793,4.753698,0.412311,-19.790907
45.000000,1.000000,0.400000,3.464823,3.464823,0.141421,-6.788225
45.000000,1.000000,5.300000,3.464823,3.464823,0.141421,-6.788225
63.434949,1.100000,0.500000,8.765386,4.382693,0.447214,-10.509519
63.434949,1.100000,5.400000,8.765386,4.382693,0.447214,-10.509519
-45.000000,1.100000,1.100000,3.464823,3.464823,0.282843,-6.646804
-45.000000,1.100000,6.000000,3.464823,3.464823,0.282843,-6.646804
90.000000,1.100000,1.100000,0.000000,4.900000,0.100000,-4.800000
90.000000,1.100000,1.200000,0.000000,4.900000,0.100000,-4.800000
-14.036243,0.700000,1.400000,19.014793,4.753698,0.412311,-19.790907
-14.036243,5.600000,1.400000,19.014793,4.753698,0.412311,-19.790907
-14.036243,10.500000,1.400000,19.014793,4.753698,0.412311,-19.790907
-14.036243,15.400000,1.400000,19.014793,4.753698,0.412311,-19.790907
0.000000,4.400000,2.500000,0.000000,4.900000,0.300000,-4.600000
26.565051,4.200000,2.400000,2.191347,4.382693,0.223607,-10.733126
26.565051,4.200000,7.300000,2.191347,4.382693,0.223607,-10.733126
26.565051,9.100000,2.400000,2.191347,4.382693,0.223607,-10.733126
26.565051,9.100000,7.300000,2.191347,4.382693,0.223607,-10.733126
90.000000,4.200000,2.300000,0.000000,4.900000,0.100000,-4.800000
63.434949,4.100000,2.100000,8.765386,4.382693,0.223607,-10.733126
63.434949,4.100000,7.000000,8.765386,4.382693,0.223607,-10.733126
45.000000,3.800000,1.800000,3.464823,3.464823,0.424264,-6.505382
45.000000,3.800000,6.700000,3.464823,3.464823,0.424264,-6.505382
90.000000,3.800000,1.600000,0.000000,4.900000,0.200000,-4.700000
-45.000000,3.800000,1.600000,3.464823,3.464823,0.282843,-6.646804
-45.000000,3.800000,6.500000,3.464823,3.464823,0.282843,-6.646804
-63.434949,4.000000,1.400000,2.191347,4.382693,0.447214,-10.509519
-63.434949,4.000000,6.300000,2.191347,4.382693,0.447214,-10.509519
0.000000,4.200000,1.000000,0.000000,4.900000,0.200000,-4.700000
63.434949,4.400000,1.000000,8.765386,4.382693,0.223607,-10.733126
63.434949,4.400000,5.900000,8.765386,4.382693,0.223607,-10.733126
71.565051,4.500000,1.200000,13.945644,4.648548,0.316228,-15.178933
71.565051,4.500000,6.100000,13.945644,4.648548,0.316228,-15.178933
71.565051,4.500000,11.000000,13.945644,4.648548,0.316228,-15.178933
45.000000,4.600000,1.500000,3.464823,3.464823,0.282843,-6.646804
45.000000,4.600000,6.400000,3.464823,3.464823,0.282843,-6.646804
90.000000,4.800000,1.700000,0.000000,4.900000,0.100000,-4.800000
90.000000,4.800000,1.800000,0.000000,4.900000,0.400000,-4.500000
90.000000,4.800000,2.200000,0.000000,4.900000,0.300000,-4.600000
0.000000,4.700000,2.500000,0.000000,4.900000,0.100000,-4.800000
90.000000,0.100000,0.300000,0.000000,4.900000,0.200000,-4.700000
-63.434949,0.100000,0.300000,2.191347,4.382693,0.223607,-10.733126
-63.434949,0.100000,5.200000,2.191347,4.382693,0.223607,-10.733126
0.000000,0.200000,0.100000,0.000000,4.900000,0.500000,-4.400000
0.000000,0.700000,0.100000,0.000000,4.900000,0.400000,-4.500000
-30.963757,0.600000,0.400000,21.008577,12.605146,0.583095,-27.988569
-30.963757,0.600000,5.300000,21.008577,12.605146,0.583095,-27.988569
-30.963757,0.600000,10.200000,21.008577,12.605146,0.583095,-27.988569
-30.963757,5.500000,0.400000,21.008577,12.605146,0.583095,-27.988569
-30.963757,5.500000,5.300000,21.008577,12.605146,0.583095,-27.988569
-30.963757,5.500000,10.200000,21.008577,12.605146,0.583095,-27.988569
-30.963757,10.400000,0.400000,21.008577,12.605146,0.583095,-27.988569
-30.963757,10.400000,5.300000,21.008577,12.605146,0.583095,-27.988569
-30.963757,10.400000,10.200000,21.008577,12.605146,0.583095,-27.988569
-30.963757,15.300000,0.400000,21.008577,12.605146,0.583095,-27.988569
-30.963757,15.300000,5.300000,21.008577,12.605146,0.583095,-27.988569
-30.963757,15.300000,10.200000,21.008577,12.605146,0.583095,-27.988569
-30.963757,20.200000,0.400000,21.008577,12.605146,0.583095,-27.988569
-30.963757,20.200000,5.300000,21.008577,12.605146,0.583095,-27.988569
-30.963757,20.200000,10.200000,21.008577,12.605146,0.583095,-27.988569
-11.309932,0.100000,0.500000,24.024227,4.804845,0.509902,-24.475294
-11.309932,0.100000,5.400000,24.024227,4.804845,0.509902,-24.475294
-11.309932,5.000000,0.500000,24.024227,4.804845,0.509902,-24.475294
-11.309932,5.000000,5.400000,24.024227,4.804845,0.509902,-24.475294
-11.309932,9.900000,0.500000,24.024227,4.804845,0.509902,-24.475294
-11.309932,9.900000,5.400000,24.024227,4.804845,0.509902,-24.475294
-11.309932,14.800000,0.500000,24.024227,4.804845,0.509902,-24.475294
-11.309932,14.800000,5.400000,24.024227,4.804845,0.509902,-24.475294
-11.309932,19.700000,0.500000,24.024227,4.804845,0.509902,-24.475294
-11.309932,19.700000,5.400000,24.024227,4.804845,0.509902,-24.475294
90.000000,3.800000,0.600000,0.000000,4.900000,0.300000,-4.600000
63.434949,3.700000,0.400000,8.765386,4.382693,0.223607,-10.733126
63.434949,3.700000,5.300000,8.765386,4.382693,0.223607,-10.733126
-71.565051,3.700000,0.400000,1.549516,4.648548,0.316228,-15.178933
-71.565051,3.700000,5.300000,1.549516,4.648548,0.316228,-15.178933
-71.565051,3.700000,10.200000,1.549516,4.648548,0.316228,-15.178933
0.000000,3.800000,0.100000,0.000000,4.900000,0.300000,-4.600000
-14.036243,4.100000,0.100000,19.014793,4.753698,0.412311,-19.790907
-14.036243,9.000000,0.100000,19.014793,4.753698,0.412311,-19.790907
-14.036243,13.900000,0.100000,19.014793,4.753698,0.412311,-19.790907
-14.036243,18.800000,0.100000,19.014793,4.753698,0.412311,-19.790907
26.565051,4.500000,0.000000,2.191347,4.382693,0.223607,-10.733126
26.565051,4.500000,4.900000,2.191347,4.382693,0.223607,-10.733126
26.565051,9.400000,0.000000,2.191347,4.382693,0.223607,-10.733126
26.565051,9.400000,4.900000,2.191347,4.382693,0.223607,-10.733126
71.565051,4.700000,0.100000,13.945644,4.648548,0.316228,-15.178933
71.565051,4.700000,5.000000,13.945644,4.648548,0.316228,-15.178933
71.565051,4.700000,9.900000,13.945644,4.648548,0.316228,-15.178933
90.000000,4.800000,0.400000,0.000000,4.900000,0.300000,-4.600000
90.000000,4.800000,0.700000,0.000000,4.900000,0.300000,-4.600000
0.000000,4.700000,1.000000,0.000000,4.900000,0.100000,-4.800000
0.000000,4.500000,1.000000,0.000000,4.900000,0.200000,-4.700000
18.434949,4.200000,0.900000,1.549516,4.648548,0.316228,-15.178933
18.434949,4.200000,5.800000,1.549516,4.648548,0.316228,-15.178933
18.434949,9.100000,0.900000,1.549516,4.648548,0.316228,-15.178933
18.434949,9.100000,5.800000,1.549516,4.648548,0.316228,-15.178933
18.434949,14.000000,0.900000,1.549516,4.648548,0.316228,-15.178933
18.434949,14.000000,5.800000,1.549516,4.648548,0.316228,-15.178933
-45.000000,4.000000,1.100000,3.464823,3.464823,0.282843,-6.646804
-45.000000,4.000000,6.000000,3.464823,3.464823,0.282843,-6.646804
0.000000,3.900000,1.100000,0.000000,4.900000,0.100000,-4.800000
63.434949,3.800000,0.900000,8.765386,4.382693,0.223607,-10.733126
63.434949,3.800000,5.800000,8.765386,4.382693,0.223607,-10.733126

*stip1,Stipple
0, 0.090,0.870, 0,1, 0,-1
0, 0.210,0.710, 0,1, 0,-1
0, 0.160,0.470, 0,1, 0,-1
0, 0.510,0.240, 0,1, 0,-1
0, 0.480,0.600, 0,1, 0,-1
0, 0.750,0.840, 0,1, 0,-1
0, 0.400,0.910, 0,1, 0,-1
0, 0.820,0.500, 0,1, 0,-1
0, 0.770,0.180, 0,1, 0,-1
0, 0.030,0.030, 0,1, 0,-1
0, 0.210,0.230, 0,1, 0,-1
0, 0.350,0.040, 0,1, 0,-1
0, 0.960,0.680, 0,1, 0,-1
0, 0.640,0.430, 0,1, 0,-1
0, 0.560,0.760, 0,1, 0,-1
0, 0.730,0.670, 0,1, 0,-1
0, 0.370,0.400, 0,1, 0,-1
0, 0.650,0.940, 0,1, 0,-1
0, 0.960,0.350, 0,1, 0,-1
0, 0.930,0.050, 0,1, 0,-1

*stip2,Stipple
0, 0.090,0.870, 0,1, 0,-1
0, 0.210,0.710, 0,1, 0,-1
0, 0.160,0.470, 0,1, 0,-1
0, 0.510,0.240, 0,1, 0,-1
0, 0.480,0.600, 0,1, 0,-1
0, 0.750,0.840, 0,1, 0,-1
0, 0.400,0.910, 0,1, 0,-1
0, 0.820,0.500, 0,1, 0,-1
0, 0.770,0.180, 0,1, 0,-1
0, 0.030,0.030, 0,1, 0,-1
0, 0.210,0.230, 0,1, 0,-1
0, 0.350,0.040, 0,1, 0,-1
0, 0.960,0.680, 0,1, 0,-1
0, 0.640,0.430, 0,1, 0,-1
0, 0.560,0.760, 0,1, 0,-1
0, 0.730,0.670, 0,1, 0,-1
0, 0.370,0.400, 0,1, 0,-1
0, 0.650,0.940, 0,1, 0,-1
0, 0.960,0.350, 0,1, 0,-1
0, 0.930,0.050, 0,1, 0,-1
75.9638, 0.180,0.570, -3.152963,0.242536, 0.041231,-4.081875
329.0362, 0.350,0.780, -3.601470,0.171499, 0.058310,-5.772642
338.1986, 0.640,0.550, 3.156821,0.185695, 0.053852,-5.331313
149.0362, 0.650,0.070, -3.601470,0.171499, 0.058310,-5.772642
53.1301, 0.340,0.200, 3.600000,0.200000, 0.050000,-4.950000
315.0000, 0.870,0.920, 0.707107,0.707107, 0.056569,-1.357645
101.3099, 0.800,0.300, 4.118439,0.196116, 0.050990,-5.048029
323.1301, 0.060,0.340, 3.600000,0.200000, 0.050000,-4.950000
315.0000, 0.180,0.970, 0.707107,0.707107, 0.042426,-1.371787

*Tes10, Spiny stars-square  (c) 1988  William Karkow
26.565051177,  0,0, .6, .2, .125,-.75,.125
63.434948823,  0,0, .6,-.2, .125,-.75,.125
296.565051177, 0,0, .6, .2, .125,-.75,.125
333.434948823, 0,0, .6,-.2, .125,-.75,.125

*Tri45, Triangles at 45 degrees.
 45, 0,0, 4.2426407,4.2425407, 1.4142136,-2.8284271
135, 0,0, 4.2426407,4.2426407, 1.4142136,-2.8284271

*vbricks,Vertical grouted bricks - TIP 322 (c)1988, Watson Kilbourne
0,    0,  0,  0,.5,  .16,-.04
0,    0,.46,  0,.5,  .16,-.04
90,   0,  0,  0,.2,  .46,-.04
90, .16,  0,  0,.2,  .46,-.04

*WATER,Water  CADalyst TIP340 (c) 1988, Watson Kilbourne
0, 0,0, 0,1, .2,-.8
45, .4,.1, .7071067812,.7071067812, .2828427125,-1.13137085
135, .8,.1, .7071067812,.7071067812, .2828427125,-1.13137085
26.5650512, .2,0, .894427191,-.447213595, .2236,-2.012467977
333.4349488, .8,.1, .894427191,.447213595, .2236,-2.012467977

*Wheat1,rolling fields
158.1986, 1.000,0.000, 3.156821,0.185695, 1.077033,-4.308132
163.3008, 1.000,0.400, 7.279480,0.095783, 1.044031,-9.396276
168.6901, 1.000,0.700, -4.118439,0.196116, 1.019804,-4.079216
174.2894, 1.000,0.900, -9.054838,0.099504, 1.004988,-9.044888

*Wheat2,rolling fields
165.9638, 1.000,0.250, -3.152963,0.242536, 1.030776,-3.092329
168.6901, 1.000,0.500, -4.118439,0.196116, 1.019804,-4.079216
171.4692, 1.000,0.700, -13.152853,0.049447, 1.011187,-19.212561
357.1376, 0.000,1.000, -19.026232,0.049938, 1.001249,-19.023735
354.2894, 0.000,0.950, -9.054838,0.099504, 1.004988,-9.044888
345.9638, 0.000,0.250, -3.152963,0.242536, 1.030776,-3.092329

*Widecros, Wide Cross  (c) 1988  William Karkow
0, 0,0, .25,.375, .125,-.25,.125
0, .125,.125, .25,.375, .25,-.25
270, 0,0, .375,.25, .25,-.5
270, .125,.125, 0,.25,0.125,-.25

*Wood_12, hatch pattern generated by HACI 1.2
47.4895, 0.86,0.055, 14.865954,0.061429, 0.162788,-16.116046
65.6589, 0.73,0.29, 34.014698,0.021693, 0.230489,-45.867237
47.0213, 0.21,0.12, 39.623264,0.016627, 0.300707,-59.840856
26.1752, 0.47,0.65, 2.236014,0.015211, 0.32871,-65.413159
50.1944, 0.095,0.475, 6.401847,0.128037, 0.31241,-7.497843
65.2248, 0.91,0.805, 12.08285,0.069843, 0.214767,-14.103061
50.7927, 0.755,0.615, 34.828191,0.020391, 0.245204,-48.795663
32.6192, 0.63,0.535, 16.643275,0.033691, 0.148408,-29.533222
14.6208, 0.4,0.475, 19.646831,0.04207, 0.237697,-23.532023
29.4274, 0.205,0.365, 26.419666,0.022333, 0.223886,-44.553315
51.9112, 0.06,0.18, 29.206167,0.021272, 0.235053,-46.775601
71.565, 0,0, 0.948683,0.316228, 0.189737,-2.972542
65.2248, 0.91,0.305, 12.08285,0.069843, 0.214767,-14.103061
50.7927, 0.755,0.115, 34.828191,0.020391, 0.245204,-48.795663
32.6192, 0.63,0.035, 16.643275,0.033691, 0.148408,-29.533222
14.6208, 0.495833,0, 19.646831,0.04207, 0.138657,-23.631064
14.6208, 0.4,0.975, 19.646831,0.04207, 0.099041,-23.67068
29.4274, 0.205,0.865, 26.419666,0.022333, 0.223886,-44.553315
51.9112, 0.06,0.68, 29.206167,0.021272, 0.235053,-46.775601
71.565, 0,0.5, 0.948683,0.316228, 0.189737,-2.972542

*wood1,wood grain
216.8699, 0.400,1.000, -3.600000,0.200000, 0.500000,-4.500000
206.5651, 1.000,0.700, 1.341641,0.447214, 1.118034,-1.118034
198.4349, 1.000,0.200, 2.213594,0.316228, 0.632456,-2.529822

*wood2,wood grain
333.4349, 0.000,0.560, -1.341641,0.447214, 0.134164,-2.101904
284.5742, 0.120,0.500, -27.892645,0.019356, 0.516624,-51.145742
252.4744, 0.250,1.000, 16.762979,0.050189, 0.199249,-19.725610
315.0000, 0.190,0.810, 0.707107,0.707107, 0.254558,-1.159655
270.0000, 0.370,0.630, 1.000,1.000, 0.190000,-0.810
309.0939, 0.370,0.440, 14.212588,0.048507, 0.412311,-20.203218
270.0000, 0.630,0.120, 1.000,1.000, 0.120000,-0.880
287.5256, 0.630,1.000, -16.762979,0.050189, 0.199249,-19.725610
303.6901, 0.690,0.810, -2.218801,0.277350, 0.216333,-3.389218
339.7751, 0.810,0.630, 11.704596,0.049386, 0.202485,-20.045972

